/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearySwarmer;
import forestry.apiculture.gui.GuiAlvearySwarmer;
import forestry.apiculture.inventory.InventorySwarmer;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.apiculture.worldgen.Hive;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescriptionSwarmer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAlvearySwarmer
extends TileAlveary
implements ISidedInventory,
IActivatable,
IAlvearyComponent.Active {
    private final InventorySwarmer inventory;
    private final Stack<ItemStack> pendingSpawns = new Stack();
    private boolean active;

    public TileAlvearySwarmer() {
        super(BlockAlvearyType.SWARMER);
        this.inventory = new InventorySwarmer(this);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        if (!this.pendingSpawns.isEmpty()) {
            this.setActive(true);
            if (tickCount % 1000 == 0) {
                this.trySpawnSwarm();
            }
        } else {
            this.setActive(false);
        }
        if (tickCount % 500 != 0) {
            return;
        }
        ItemStack princessStack = this.getPrincessStack();
        if (princessStack == null) {
            return;
        }
        int chance = this.consumeInducerAndGetChance();
        if (chance == 0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextInt(1000) >= chance) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(princessStack);
        princess.setIsNatural(false);
        this.pendingSpawns.push(BeeManager.beeRoot.getMemberStack(princess, EnumBeeType.PRINCESS));
    }

    @Override
    public void updateClient(int tickCount) {
    }

    @Nullable
    private ItemStack getPrincessStack() {
        ItemStack princessStack = ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory().getQueen();
        if (BeeManager.beeRoot.isMated(princessStack)) {
            return princessStack;
        }
        return null;
    }

    private int consumeInducerAndGetChance() {
        for (int slotIndex = 0; slotIndex < this.func_70302_i_(); ++slotIndex) {
            ItemStack stack = this.func_70301_a(slotIndex);
            for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
                if (!ItemStackUtil.isIdenticalItem(entry.getKey(), stack)) continue;
                this.func_70298_a(slotIndex, 1);
                return entry.getValue();
            }
        }
        return 0;
    }

    private void trySpawnSwarm() {
        int z;
        ItemStack toSpawn = this.pendingSpawns.peek();
        HiveDescriptionSwarmer hiveDescription = new HiveDescriptionSwarmer(toSpawn);
        Hive hive = new Hive(hiveDescription);
        int x = this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextInt(80) - 40;
        if (HiveDecorator.tryGenHive(this.field_145850_b, this.field_145850_b.field_73012_v, x, z = this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextInt(80) - 40, hive)) {
            this.pendingSpawns.pop();
        }
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setActive(nbttagcompound.func_74767_n("Active"));
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingSpawns.add(new ItemStack(nbttagcompound1));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("Active", this.active);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingSpawns", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiAlvearySwarmer(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerAlvearySwarmer(player.field_71071_by, this);
    }
}

