/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.recipes;

import javax.annotation.Nullable;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

import net.minecraftforge.common.ForgeHooks;

import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.config.Constants;

public class MatingRecipe implements IRecipe {

	private final ItemStack unknown;
	@Nullable
	private ItemStack cached;

	public MatingRecipe() {
		unknown = ButterflyManager.butterflyRoot.getMemberStack(ButterflyManager.butterflyRoot.getIndividualTemplates().get(0), EnumFlutterType.BUTTERFLY);
	}

	@Override
	public boolean func_77569_a(InventoryCrafting crafting, World world) {

		boolean mated = true;
		int butterflies = 0;
		int sera = 0;

		for (int i = 0; i < crafting.func_70302_i_(); i++) {
			if (ButterflyManager.butterflyRoot.isMember(crafting.func_70301_a(i), EnumFlutterType.BUTTERFLY)) {
				butterflies++;
				mated = ButterflyManager.butterflyRoot.isMated(crafting.func_70301_a(i));
				cached = crafting.func_70301_a(i);
			} else if (ButterflyManager.butterflyRoot.isMember(crafting.func_70301_a(i), EnumFlutterType.SERUM)) {
				sera++;
			}
		}

		return !mated && butterflies == 1 && sera == 1;
	}

	@Override
	public ItemStack func_77571_b() {
		if (cached != null) {
			return cached;
		} else {
			return unknown;
		}
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting crafting) {
		IButterfly butterfly = null;
		IButterfly serum = null;
		for (int i = 0; i < crafting.func_70302_i_(); i++) {
			if (ButterflyManager.butterflyRoot.isMember(crafting.func_70301_a(i), EnumFlutterType.BUTTERFLY)) {
				butterfly = ButterflyManager.butterflyRoot.getMember(crafting.func_70301_a(i));
			} else if (ButterflyManager.butterflyRoot.isMember(crafting.func_70301_a(i), EnumFlutterType.SERUM)) {
				serum = ButterflyManager.butterflyRoot.getMember(crafting.func_70301_a(i));
			}
		}
		if (butterfly == null || serum == null) {
			return ItemStack.field_190927_a;
		}

		IButterfly mated = butterfly.copy();
		mated.mate(serum);
		return ButterflyManager.butterflyRoot.getMemberStack(mated, EnumFlutterType.BUTTERFLY);
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return width * height >= 2;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
		NonNullList<ItemStack> aitemstack = NonNullList.func_191197_a(inv.func_70302_i_(), ItemStack.field_190927_a);

		for (int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack itemstack = inv.func_70301_a(i);
			aitemstack.set(i, ForgeHooks.getContainerItem(itemstack));
		}
		return aitemstack;
	}
	
	@Override
	public IRecipe setRegistryName(ResourceLocation name) {
		throw new IllegalStateException();
	}
	
	@Nullable
	@Override
	public ResourceLocation getRegistryName() {
		return new ResourceLocation(Constants.MOD_ID, "butterflyMating");
	}
	
	@Override
	public Class<IRecipe> getRegistryType() {
		return IRecipe.class;
	}
}
