package forestry.core.blocks;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.Config;
import forestry.core.config.Constants;

public class BlockHumus extends Block implements IItemModelRegister {
	private static final int degradeDelimiter = Config.humusDegradeDelimiter;
	public static final PropertyInteger DEGRADE = PropertyInteger.func_177719_a("degrade", 0, degradeDelimiter); // degradation level of humus

	public BlockHumus() {
		super(Material.field_151578_c);
		func_149675_a(true);
		func_149711_c(0.5f);
		func_149672_a(SoundType.field_185849_b);
		func_149647_a(CreativeTabForestry.tabForestry);

		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DEGRADE, 0));
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(DEGRADE);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(DEGRADE, meta);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, DEGRADE);
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return state.func_177229_b(DEGRADE);
	}

	@Override
	public int func_149738_a(World world) {
		return 500;
	}
	
	@Override
	public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		drops.add(new ItemStack(Blocks.field_150346_d));
	}

	@Override
	public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
		if (world.field_72995_K || world.field_73012_v.nextInt(140) != 0) {
			return;
		}

		if (isEnrooted(world, pos)) {
			degradeSoil(world, pos);
		}
	}

	private static boolean isEnrooted(World world, BlockPos pos) {
		for (int i = -1; i < 2; i++) {
			for (int j = -1; j < 2; j++) {
				if (i == 0 && j == 0) {
					continue; // We are not returning true if we are the base of a sapling.
				}
				BlockPos blockPos = pos.func_177982_a(i, 1, j);
				IBlockState state = world.func_180495_p(blockPos);
				Block block = state.func_177230_c();
				if (block instanceof BlockLog || block instanceof IGrowable) {
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * If a tree or sapling is in the vicinity, there is a chance, that the soil will degrade.
	 */
	private static void degradeSoil(World world, final BlockPos pos) {
		IBlockState blockState = world.func_180495_p(pos);

		int degrade = blockState.func_177229_b(DEGRADE);
		degrade++;

		if (degrade >= degradeDelimiter) {
			world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), Constants.FLAG_BLOCK_SYNC);
		} else {
			world.func_180501_a(pos, blockState.func_177226_a(DEGRADE, degrade), Constants.FLAG_BLOCK_SYNC);
		}
		world.func_175704_b(pos, pos);
	}

	@Override
	public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
		EnumPlantType plantType = plantable.getPlantType(world, pos);
		return plantType == EnumPlantType.Crop || plantType == EnumPlantType.Plains;
	}

	@Override
	public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
		return false;
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		list.add(new ItemStack(this));
	}

	/* MODELS */
	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		for(int i = 0;i < degradeDelimiter;i++){
			manager.registerItemModel(item, i, "soil/humus");
		}
	}
}
