/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.multiblock.IFarmComponent;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TileFarmGearbox
extends TileFarm
implements IFarmComponent.Active {
    private static final int WORK_CYCLES = 4;
    private static final int ENERGY_PER_OPERATION = 200;
    private final EnergyManager energyManager = new EnergyManager(200, 10000);
    private int activationDelay = 0;
    private int previousDelays = 0;
    private int workCounter;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.activationDelay = nbttagcompound.func_74762_e("ActivationDelay");
        this.previousDelays = nbttagcompound.func_74762_e("PrevDelays");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("ActivationDelay", this.activationDelay);
        nbttagcompound.func_74768_a("PrevDelays", this.previousDelays);
        return nbttagcompound;
    }

    @Override
    public void updateServer(int tickCount) {
        if (this.energyManager.getEnergyStored() <= 0) {
            return;
        }
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.workCounter < 4 && EnergyHelper.consumeEnergyToDoWork(this.energyManager, 4, 200)) {
            ++this.workCounter;
        }
        if (this.workCounter >= 4 && tickCount % 5 == 0) {
            IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.getMultiblockLogic()).getController();
            if (farmController.doWork()) {
                this.workCounter = 0;
                this.previousDelays = 0;
            } else {
                this.activationDelay = 10 * this.previousDelays < 120 ? 10 * this.previousDelays : 120;
                ++this.previousDelays;
            }
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.energyManager.hasCapability(capability) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T energyCapability = this.energyManager.getCapability(capability);
        if (energyCapability != null) {
            return energyCapability;
        }
        return (T)super.getCapability(capability, facing);
    }
}

