/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.elements.GuiElementScrollable;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import java.util.List;
import javax.annotation.Nullable;

public class WidgetElementProvider
extends Widget
implements IScrollable {
    protected GuiElementScrollable scrollable;

    public WidgetElementProvider(WidgetManager manager, int xPos, int yPos, int width, int height, GuiElementScrollable scrollable) {
        super(manager, xPos, yPos);
        this.scrollable = scrollable;
        this.width = width;
        this.height = height;
    }

    @Override
    public void draw(int startX, int startY) {
        this.scrollable.draw(startX + this.xPos, startY + this.yPos);
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        List<String> tooltip = this.scrollable.getToolTip(mouseX -= this.xPos, mouseY -= this.yPos);
        if (tooltip.isEmpty()) {
            return null;
        }
        ToolTip toolTip = new ToolTip();
        toolTip.add(tooltip);
        return toolTip;
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.scrollable.isFocused(mouseX -= this.xPos, mouseY -= this.yPos);
    }

    @Override
    public void onScroll(int value) {
        this.scrollable.onScroll(value);
    }
}

