/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.IGuiElement;
import forestry.api.core.IGuiElementLayout;
import forestry.core.gui.elements.GuiElementLayout;

public class GuiElementHorizontal
extends GuiElementLayout {
    public GuiElementHorizontal(int xPos, int yPos, int height) {
        super(xPos, yPos, 0, height);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public IGuiElementLayout addElement(IGuiElement element) {
        this.elements.add(element);
        element.setXOffset(this.width);
        this.width += element.getWidth() + this.distance;
        return this;
    }

    @Override
    public IGuiElementLayout removeElement(IGuiElement element) {
        this.elements.remove(element);
        this.width -= element.getWidth() + this.distance;
        element.setXOffset(0);
        return this;
    }

    @Override
    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        int height = 0;
        for (IGuiElement element : this.elements) {
            int elementHeight = element.getHeight();
            if (elementHeight <= height) continue;
            height = elementHeight;
        }
        return height;
    }
}

