/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.ModuleCore;
import forestry.core.blocks.EnumResourceType;
import forestry.core.blocks.IBlockWithMeta;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockResourceOre
extends Block
implements IItemModelRegister,
IBlockWithMeta {
    public static final PropertyEnum<EnumResourceType> ORE_RESOURCES = PropertyEnum.func_177708_a((String)"resource", EnumResourceType.class, input -> input != null && input.hasOre());

    public BlockResourceOre() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(CreativeTabForestry.tabForestry);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ORE_RESOURCES, (Comparable)((Object)EnumResourceType.APATITE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORE_RESOURCES});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumResourceType)((Object)state.func_177229_b(ORE_RESOURCES))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORE_RESOURCES, (Comparable)((Object)EnumResourceType.VALUES[meta]));
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(world, pos, state, chance, fortune);
        if (state.func_177229_b(ORE_RESOURCES) == EnumResourceType.APATITE) {
            this.func_180637_b(world, pos, MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)4));
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumResourceType type = (EnumResourceType)((Object)state.func_177229_b(ORE_RESOURCES));
        switch (type) {
            case APATITE: {
                int amount;
                int fortuneModifier = RANDOM.nextInt(fortune + 2) - 1;
                if (fortuneModifier < 0) {
                    fortuneModifier = 0;
                }
                if ((amount = (2 + RANDOM.nextInt(5)) * (fortuneModifier + 1)) <= 0) break;
                drops.add((Object)ModuleCore.getItems().apatite.getItemStack(amount));
                break;
            }
            case TIN: {
                drops.add((Object)new ItemStack((Block)this, 1, this.func_180651_a(state)));
                break;
            }
            case COPPER: {
                drops.add((Object)new ItemStack((Block)this, 1, this.func_180651_a(state)));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumResourceType resourceType : ORE_RESOURCES.func_177700_c()) {
            list.add((Object)this.get(resourceType, 1));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "ores/apatite");
        manager.registerItemModel(item, 1, "ores/copper");
        manager.registerItemModel(item, 2, "ores/tin");
    }

    public ItemStack get(EnumResourceType type, int amount) {
        return new ItemStack((Block)this, amount, type.getMeta());
    }

    @Override
    public String getNameFromMeta(int meta) {
        EnumResourceType resourceType = (EnumResourceType)((Object)this.func_176203_a(meta).func_177229_b(ORE_RESOURCES));
        return resourceType.func_176610_l();
    }
}

