/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.network;

import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketRipeningUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final int value;

    public PacketRipeningUpdate(TileLeaves leaves) {
        this.pos = leaves.func_174877_v();
        this.value = leaves.getFruitColour();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.RIPENING_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.func_150787_b(this.value);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            int value = data.func_150792_a();
            TileUtil.actOnTile((IBlockAccess)player.field_70170_p, pos, IRipeningPacketReceiver.class, tile -> tile.fromRipeningPacket(value));
        }
    }
}

