/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.storage;

import javax.annotation.Nullable;

public enum BackpackMode {
	NORMAL(null),
	LOCKED("for.storage.backpack.mode.locked"),
	RECEIVE("for.storage.backpack.mode.receiving"),
	RESUPPLY("for.storage.backpack.mode.resupply");

	@Nullable
	private final String unlocalizedInfo;

	BackpackMode(@Nullable String unlocalizedInfo) {
		this.unlocalizedInfo = unlocalizedInfo;
	}

	@Nullable
	public String getUnlocalizedInfo() {
		return unlocalizedInfo;
	}
}
