package forestry.core.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;

public class BlockResourceStorage extends Block implements IItemModelRegister, IBlockWithMeta {
	public static final PropertyEnum<EnumResourceType> STORAGE_RESOURCES = PropertyEnum.func_177709_a("resource", EnumResourceType.class);

	public BlockResourceStorage() {
		super(Material.field_151573_f);
		func_149711_c(3F);
		func_149752_b(5F);
		func_149647_a(CreativeTabForestry.tabForestry);
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STORAGE_RESOURCES, EnumResourceType.APATITE));
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, STORAGE_RESOURCES);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(STORAGE_RESOURCES).getMeta();
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(STORAGE_RESOURCES, EnumResourceType.VALUES[meta]);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (EnumResourceType resourceType : EnumResourceType.VALUES) {
			list.add(get(resourceType));
		}
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (EnumResourceType resourceType : EnumResourceType.VALUES) {
			manager.registerItemModel(item, resourceType.getMeta(), "storage/" + resourceType.func_176610_l());
		}
	}

	public ItemStack get(EnumResourceType type) {
		return new ItemStack(this, 1, type.getMeta());
	}

	@Override
	public String getNameFromMeta(int meta) {
		EnumResourceType resourceType = func_176203_a(meta).func_177229_b(STORAGE_RESOURCES);
		return resourceType.func_176610_l();
	}
}
