/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory.wrappers;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

/**
 * Wrapper class used to specify part of an existing inventory to be treated as
 * a complete inventory. Used primarily to map a side of an ISidedInventory, but
 * it is also helpful for complex inventories such as the Tunnel Bore.
 *
 * @author CovertJaguar <http://www.railcraft.info>
 */
public class InventoryMapper extends InvWrapperBase implements IInventory {

	private final IInventory inv;
	private final int start;
	private final int size;
	private int stackSizeLimit = -1;

	public InventoryMapper(IInventory inv) {
		this(inv, 0, inv.func_70302_i_(), true);
	}

	public InventoryMapper(IInventory inv, boolean checkItems) {
		this(inv, 0, inv.func_70302_i_(), checkItems);
	}

	/**
	 * Creates a new InventoryMapper
	 *
	 * @param inv   The backing inventory
	 * @param start The starting index
	 * @param size  The size of the new inventory, take care not to exceed the
	 *              end of the backing inventory
	 */
	public InventoryMapper(IInventory inv, int start, int size) {
		this(inv, start, size, true);
	}

	public InventoryMapper(IInventory inv, int start, int size, boolean checkItems) {
		super(inv, checkItems);
		this.inv = inv;
		this.start = start;
		this.size = size;
	}

	@Override
	public boolean func_191420_l() {
		return inv.func_191420_l();
	}

	@Override
	public int func_70302_i_() {
		return size;
	}

	@Override
	public ItemStack func_70301_a(int slot) {
		return inv.func_70301_a(start + slot);
	}

	@Override
	public ItemStack func_70298_a(int slot, int amount) {
		return inv.func_70298_a(start + slot, amount);
	}

	@Override
	public void func_70299_a(int slot, ItemStack itemstack) {
		inv.func_70299_a(start + slot, itemstack);
	}

	public void setStackSizeLimit(int limit) {
		stackSizeLimit = limit;
	}

	@Override
	public int func_70297_j_() {
		return stackSizeLimit > 0 ? stackSizeLimit : inv.func_70297_j_();
	}

	@Override
	public boolean func_94041_b(int slot, ItemStack stack) {
		return !checkItems() || inv.func_94041_b(start + slot, stack);
	}

}
