/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class InventoryAdapterTile<T extends TileEntity> extends InventoryAdapterRestricted {

	protected final T tile;

	public InventoryAdapterTile(T tile, int size, String name) {
		this(tile, size, name, 64);
	}

	public InventoryAdapterTile(T tile, int size, String name, int stackLimit) {
		super(size, name, stackLimit);
		this.tile = tile;
	}

	@Override
	public void func_70296_d() {
		super.func_70296_d();
		tile.func_70296_d();
	}

	@Override
	public boolean func_180461_b(int slotIndex, ItemStack stack, EnumFacing side) {
		return false;
	}
}
