/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.plugins.CompatPlugin;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry_compat", moduleID="actuallyadditions", name="Actually Additions", author="Ellpeck", url="http://ellpeck.de/actadd", unlocalizedDescription="for.module.actuallyadditions.description")
public class PluginActuallyAdditions
extends CompatPlugin {
    private static final String ACT_ADD = "actuallyadditions";

    public PluginActuallyAdditions() {
        super("Actually Additions", ACT_ADD);
    }

    @Override
    public void registerRecipes() {
        Item canolaSeed = this.getItem("item_canola_seed");
        Item flaxSeed = this.getItem("item_flax_seed");
        Item riceSeed = this.getItem("item_rice_seed");
        Item coffeeSeed = this.getItem("item_coffee_seed");
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "farming"))) {
            this.registerSeedPlant(canolaSeed, "block_canola");
            this.registerSeedPlant(flaxSeed, "block_flax");
            this.registerSeedPlant(riceSeed, "block_rice");
            this.registerSeedPlant(coffeeSeed, "block_coffee");
        }
        int amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        FluidStack seedFluid = Fluids.SEED_OIL.getFluid(amount);
        for (Item seed : Arrays.asList(canolaSeed, flaxSeed, riceSeed, coffeeSeed)) {
            if (seed == null) continue;
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(seed), seedFluid);
        }
        Fluid canolaOil = this.getFluid("canolaoil");
        if (canolaOil != null) {
            Fluid oil;
            Item misc = this.getItem("item_misc");
            if (misc != null) {
                ItemStack canola = new ItemStack(misc, 1, 13);
                RecipeManagers.squeezerManager.addRecipe(15, canola, new FluidStack(canolaOil, 80));
            }
            if ((oil = this.getFluid("refinedcanolaoil")) != null) {
                RecipeManagers.stillManager.addRecipe(200, new FluidStack(canolaOil, 5), new FluidStack(oil, 5));
            }
        }
    }

    private void registerSeedPlant(@Nullable Item seedItem, String blockName) {
        Block plantBlock;
        if (seedItem != null && (plantBlock = this.getBlock(blockName)) != null) {
            FarmableAgingCrop crop = new FarmableAgingCrop(new ItemStack(seedItem), plantBlock, (IProperty<Integer>)BlockCrops.field_176488_a, 7);
            ForestryAPI.farmRegistry.registerFarmables("farmWheat", crop);
            FarmableAgingCrop cropOrchard = new FarmableAgingCrop(new ItemStack(seedItem), plantBlock, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0);
            ForestryAPI.farmRegistry.registerFarmables("farmOrchard", cropOrchard);
        }
    }
}

