/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate.modifiers;

import forestry.api.climate.ClimateStateType;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStates;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.ModuleGreenhouse;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.climate.IClimateModifier;
import forestry.greenhouse.api.climate.IClimateSource;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClimateSourceModifier
implements IClimateModifier {
    public static final float CLIMATE_CHANGE = 0.01f;

    @Override
    public IClimateState modifyTarget(IClimateContainer container, IClimateState newState, IClimateState previousState, NBTTagCompound data) {
        Collection<IClimateSource> sources = container.getClimateSources();
        if (sources.isEmpty()) {
            data.func_82580_o("rangeUp");
            data.func_82580_o("rangeDown");
            data.func_82580_o("change");
            return newState;
        }
        container.recalculateBoundaries();
        IClimateState boundaryUp = container.getBoundaryUp();
        IClimateState boundaryDown = container.getBoundaryDown();
        data.func_74782_a("rangeUp", (NBTBase)boundaryUp.writeToNBT(new NBTTagCompound()));
        data.func_74782_a("rangeDown", (NBTBase)boundaryDown.writeToNBT(new NBTTagCompound()));
        IClimateState targetedState = container.getTargetedState();
        if (!targetedState.isPresent()) {
            return newState;
        }
        IClimateState target = this.getTargetOrBound(previousState, container.getBoundaryDown(), container.getBoundaryUp(), targetedState);
        IClimateState changeState = ClimateStates.extendedZero();
        for (IClimateSource source : container.getClimateSources()) {
            newState = newState.add(source.getState());
        }
        for (IClimateSource source : container.getClimateSources()) {
            IClimateState state = source.work(previousState, target, newState, container.getSizeModifier(), container.canWork());
            changeState = changeState.add(source.getState());
            newState = newState.add(state);
        }
        data.func_74782_a("change", (NBTBase)changeState.writeToNBT(new NBTTagCompound()));
        return newState;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(IClimateContainer container, NBTTagCompound nbtData, ClimateType type, List<String> lines) {
        IClimateState rangeDown = ClimateStates.INSTANCE.create(nbtData.func_74775_l("rangeDown"), ClimateStateType.DEFAULT);
        IClimateState rangeUp = ClimateStates.INSTANCE.create(nbtData.func_74775_l("rangeUp"), ClimateStateType.DEFAULT);
        IClimateState change = ClimateStates.INSTANCE.create(nbtData.func_74775_l("change"), ClimateStateType.EXTENDED);
        if (type == ClimateType.HUMIDITY) {
            lines.add(Translator.translateToLocalFormatted("for.gui.modifier.sources.range.up", StringUtil.floatAsPercent(rangeUp.getHumidity())));
            lines.add(Translator.translateToLocalFormatted("for.gui.modifier.sources.range.down", StringUtil.floatAsPercent(rangeDown.getHumidity())));
            lines.add(Translator.translateToLocalFormatted("for.gui.modifier.sources.change", StringUtil.floatAsPercent(change.getHumidity())));
        } else {
            lines.add(Translator.translateToLocalFormatted("for.gui.modifier.sources.range.up", StringUtil.floatAsPercent(rangeUp.getTemperature())));
            lines.add(Translator.translateToLocalFormatted("for.gui.modifier.sources.range.down", StringUtil.floatAsPercent(rangeDown.getTemperature())));
            lines.add(Translator.translateToLocalFormatted("for.gui.modifier.sources.change", StringUtil.floatAsPercent(change.getTemperature())));
        }
    }

    @Override
    public boolean canModify(ClimateType type) {
        return true;
    }

    @Override
    public String getName() {
        return Translator.translateToLocal("for.gui.modifier.sources.title");
    }

    @Override
    public int getPriority() {
        return -1;
    }

    private IClimateState getTargetOrBound(IClimateState climateState, IClimateState boundaryDown, IClimateState boundaryUp, IClimateState targetedState) {
        float temperature = climateState.getTemperature();
        float humidity = climateState.getHumidity();
        float targetTemperature = targetedState.getTemperature();
        float targetHumidity = targetedState.getHumidity();
        if (targetTemperature > temperature) {
            temperature = Math.min(targetTemperature, boundaryUp.getTemperature());
        } else if (targetTemperature < temperature) {
            temperature = Math.max(targetTemperature, boundaryDown.getTemperature());
        }
        if (targetHumidity > humidity) {
            humidity = Math.min(targetHumidity, boundaryUp.getHumidity());
        } else if (targetHumidity < humidity) {
            humidity = Math.max(targetHumidity, boundaryDown.getHumidity());
        }
        return ClimateStates.of(temperature, humidity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getIconItemStack() {
        return ModuleGreenhouse.getBlocks().window.getItem("glass");
    }
}

