/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.utils.InventoryUtil;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.tiles.TileSqueezer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class InventorySqueezer
extends InventoryAdapterTile<TileSqueezer> {
    public static final short SLOT_RESOURCE_1 = 0;
    public static final short SLOTS_RESOURCE_COUNT = 9;
    public static final short SLOT_REMNANT = 9;
    public static final short SLOT_REMNANT_COUNT = 1;
    public static final short SLOT_CAN_INPUT = 10;
    public static final short SLOT_CAN_OUTPUT = 11;

    public InventorySqueezer(TileSqueezer squeezer) {
        super(squeezer, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 10) {
            return FluidHelper.isFillableEmptyContainer(itemStack);
        }
        if (slotIndex >= 0 && slotIndex < 9) {
            if (FluidHelper.isFillableEmptyContainer(itemStack)) {
                return false;
            }
            if (SqueezerRecipeManager.canUse(itemStack)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, EnumFacing side) {
        return slotIndex == 9 || slotIndex == 11;
    }

    public boolean hasResources() {
        return !InventoryUtil.isEmpty((IInventory)this, 0, 9);
    }

    public NonNullList<ItemStack> getResources() {
        return InventoryUtil.getStacks((IInventory)this, 0, 9);
    }

    public boolean removeResources(NonNullList<ItemStack> stacks) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 0, 9);
        return InventoryUtil.removeSets((IInventory)inventory, 1, stacks, null, false, true, false, true);
    }

    public boolean addRemnant(ItemStack remnant, boolean doAdd) {
        return InventoryUtil.tryAddStack((IInventory)this, remnant, 9, 1, true, doAdd);
    }

    public void fillContainers(FluidStack fluidStack, TankManager tankManager) {
        if (this.func_70301_a(10).func_190926_b()) {
            return;
        }
        FluidHelper.fillContainers(tankManager, (IInventory)this, 10, 11, fluidStack.getFluid(), true);
    }
}

