/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui.widgets;

import forestry.api.genetics.EnumDatabaseTab;
import forestry.api.genetics.IDatabaseTab;
import forestry.core.gui.elements.GuiElementHelper;
import forestry.core.gui.elements.GuiElementScrollable;
import forestry.core.gui.widgets.WidgetElementProvider;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.core.utils.SoundUtil;
import forestry.core.utils.Translator;
import forestry.database.DatabaseScreenLogic;
import forestry.database.gui.widgets.WidgetDatabaseTabs;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class WidgetDatabaseScreen
extends WidgetElementProvider {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/database_mutation_screen.png");
    private WidgetDatabaseTabs tabs;
    public WidgetScrollBar scrollBar;
    public GuiElementHelper layoutHelper;
    public DatabaseScreenLogic logic;
    public DatabaseScreenLogic.ScreenState state;

    public WidgetDatabaseScreen(WidgetManager manager, int xPos, int yPos, WidgetScrollBar scrollBar) {
        super(manager, xPos, yPos, 118, 177, new GuiElementScrollable(0, 0, 102, 157));
        this.scrollable.setXOffset(8);
        this.scrollable.setYOffset(12);
        this.scrollBar = scrollBar;
        this.logic = new DatabaseScreenLogic();
        this.state = DatabaseScreenLogic.ScreenState.NO_INDIVIDUAL;
    }

    public void setTabs(WidgetDatabaseTabs tabs) {
        this.tabs = tabs;
    }

    public int onTabChange(EnumDatabaseTab tab) {
        this.state = this.logic.onTabChange(this.logic.tabs[tab.ordinal()]);
        this.update();
        if (this.state == DatabaseScreenLogic.ScreenState.SUCCESS) {
            SoundUtil.playButtonClick();
            return this.logic.selectedTab.getTab().ordinal();
        }
        return -1;
    }

    public void onItemChange(ItemStack itemStack) {
        this.state = this.logic.onItemChange(itemStack);
        this.update();
        this.tabs.selectedTab = this.state == DatabaseScreenLogic.ScreenState.SUCCESS ? this.logic.selectedTab.getTab().ordinal() : -1;
    }

    public ItemStack getItemStack(EnumDatabaseTab tab) {
        if (this.state == DatabaseScreenLogic.ScreenState.SUCCESS) {
            return this.logic.databasePlugin.getTabDatabaseIconItem(tab);
        }
        return new ItemStack(Items.field_151121_aF);
    }

    public String getTooltip(EnumDatabaseTab tab) {
        String tooltip;
        if (this.state == DatabaseScreenLogic.ScreenState.SUCCESS && (tooltip = this.logic.tabs[tab.ordinal()].getTooltip(this.logic.individual)) != null) {
            return tooltip;
        }
        return Translator.translateToLocal("for.gui.database.tab." + tab.toString().toLowerCase(Locale.ENGLISH) + ".name");
    }

    private void update() {
        this.scrollable.clear();
        this.scrollBar.setVisible(false);
        this.scrollable.updateVisibleElements(0);
        this.layoutHelper = new GuiElementHelper(this.scrollable);
        if (this.state == DatabaseScreenLogic.ScreenState.SUCCESS) {
            IDatabaseTab selectedTab = this.logic.selectedTab;
            selectedTab.createElements(this.layoutHelper, this.logic.individual, this.logic.itemStack);
            int invisibleElements = this.scrollable.getInvisibleElementCount();
            if (invisibleElements > 0) {
                this.scrollBar.setParameters(this, 0, invisibleElements, 1);
                this.scrollBar.setVisible(true);
            } else {
                this.scrollBar.setValue(0);
            }
            this.scrollable.updateVisibleElements(this.scrollBar.getValue());
        } else {
            GuiElementHelper layoutHelper = new GuiElementHelper(this.scrollable);
            FontRenderer fontRenderer = this.manager.gui.getFontRenderer();
            String key = "for.gui.portablealyzer.help";
            if (this.state == DatabaseScreenLogic.ScreenState.NO_PLUGIN) {
                key = "for.gui.database.support";
            }
            List lines = fontRenderer.func_78271_c(Translator.translateToLocal(key), this.width - 10);
            for (String text : lines) {
                layoutHelper.addText(2, text, -1);
            }
            this.scrollable.updateVisibleElements(0);
        }
    }

    @Override
    public void draw(int startX, int startY) {
        this.tabs.drawTabs(startX, startY);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TEXTURE);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 0, 0, this.width, this.height);
        this.tabs.drawSelectedTab(startX, startY);
        super.draw(startX, startY);
    }

    public int size() {
        return this.scrollable.getSize();
    }
}

