/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ArboricultureCapabilities;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesRootPollinatable;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.genetics.ItemGE;
import forestry.core.tiles.TileUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneticsUtil {
    public static boolean hasNaturalistEye(EntityPlayer player) {
        IArmorNaturalist armorNaturalist;
        ItemStack armorItemStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (armorItemStack.func_190926_b()) {
            return false;
        }
        Item armorItem = armorItemStack.func_77973_b();
        if (armorItem instanceof IArmorNaturalist) {
            armorNaturalist = (IArmorNaturalist)armorItem;
        } else if (armorItemStack.hasCapability(ArboricultureCapabilities.ARMOR_NATURALIST, null)) {
            armorNaturalist = (IArmorNaturalist)armorItemStack.getCapability(ArboricultureCapabilities.ARMOR_NATURALIST, null);
        } else {
            return false;
        }
        return armorNaturalist != null && armorNaturalist.canSeePollination(player, armorItemStack, true);
    }

    public static boolean canNurse(IButterfly butterfly, World world, BlockPos pos) {
        IButterflyNursery tile = TileUtil.getTile((IBlockAccess)world, pos, IButterflyNursery.class);
        return tile != null && tile.canNurse(butterfly);
    }

    @Nullable
    public static ICheckPollinatable getCheckPollinatable(World world, BlockPos pos) {
        ISpeciesRoot root;
        IPollinatable tile = TileUtil.getTile((IBlockAccess)world, pos, IPollinatable.class);
        if (tile != null) {
            return tile;
        }
        IIndividual pollen = GeneticsUtil.getPollen(world, pos);
        if (pollen != null && (root = pollen.getGenome().getSpeciesRoot()) instanceof ISpeciesRootPollinatable) {
            return ((ISpeciesRootPollinatable)root).createPollinatable(pollen);
        }
        return null;
    }

    @Nullable
    public static IPollinatable getOrCreatePollinatable(@Nullable GameProfile owner, World world, BlockPos pos, boolean convertVanilla) {
        ISpeciesRoot root;
        IIndividual pollen;
        IPollinatable pollinatable = TileUtil.getTile((IBlockAccess)world, pos, IPollinatable.class);
        if (pollinatable == null && convertVanilla && (pollen = GeneticsUtil.getPollen(world, pos)) != null && (root = pollen.getGenome().getSpeciesRoot()) instanceof ISpeciesRootPollinatable) {
            ISpeciesRootPollinatable rootPollinatable = (ISpeciesRootPollinatable)root;
            pollinatable = rootPollinatable.tryConvertToPollinatable(owner, world, pos, pollen);
        }
        return pollinatable;
    }

    @Nullable
    public static IButterflyNursery getOrCreateNursery(@Nullable GameProfile gameProfile, World world, BlockPos pos, boolean convertVanilla) {
        ITree treeLeave;
        IIndividual pollen;
        IButterflyNursery nursery = GeneticsUtil.getNursery(world, pos);
        if (nursery == null && convertVanilla && (pollen = GeneticsUtil.getPollen(world, pos)) instanceof ITree && (treeLeave = (ITree)pollen).setLeaves(world, gameProfile, pos)) {
            nursery = GeneticsUtil.getNursery(world, pos);
        }
        return nursery;
    }

    public static boolean canCreateNursery(World world, BlockPos pos) {
        IIndividual pollen = GeneticsUtil.getPollen(world, pos);
        return pollen != null && pollen instanceof ITree;
    }

    @Nullable
    public static IButterflyNursery getNursery(World world, BlockPos pos) {
        return TileUtil.getTile((IBlockAccess)world, pos, IButterflyNursery.class);
    }

    @Nullable
    public static IIndividual getPollen(World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        ICheckPollinatable checkPollinatable = TileUtil.getTile((IBlockAccess)world, pos, ICheckPollinatable.class);
        if (checkPollinatable != null) {
            return checkPollinatable.getPollen();
        }
        IBlockState blockState = world.func_180495_p(pos);
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            Object individual = root.translateMember(blockState);
            if (individual == null) continue;
            return individual;
        }
        return null;
    }

    @Nullable
    public static IIndividual getGeneticEquivalent(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemGE) {
            return ((ItemGE)item).getIndividual(itemStack);
        }
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            Object individual = root.translateMember(itemStack);
            if (individual == null) continue;
            return individual;
        }
        return null;
    }

    public static ItemStack convertToGeneticEquivalent(ItemStack foreign) {
        IIndividual individual;
        if (AlleleManager.alleleRegistry.getSpeciesRoot(foreign) == null && (individual = GeneticsUtil.getGeneticEquivalent(foreign)) != null) {
            ItemStack equivalent = TreeManager.treeRoot.getMemberStack(individual, EnumGermlingType.SAPLING);
            equivalent.func_190920_e(foreign.func_190916_E());
            return equivalent;
        }
        return foreign;
    }

    public static int getResearchComplexity(IAlleleSpecies species, IChromosomeType speciesChromosome) {
        return 1 + GeneticsUtil.getGeneticAdvancement(species, new HashSet<IAlleleSpecies>(), speciesChromosome);
    }

    private static int getGeneticAdvancement(IAlleleSpecies species, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        int highest = 0;
        exclude.add(species);
        for (IMutation iMutation : species.getRoot().getPaths(species, speciesChromosome)) {
            highest = GeneticsUtil.getHighestAdvancement(iMutation.getAllele0(), highest, exclude, speciesChromosome);
            highest = GeneticsUtil.getHighestAdvancement(iMutation.getAllele1(), highest, exclude, speciesChromosome);
        }
        return 1 + highest;
    }

    private static int getHighestAdvancement(IAlleleSpecies mutationSpecies, int highest, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        if (exclude.contains(mutationSpecies) || AlleleManager.alleleRegistry.isBlacklisted(mutationSpecies.getUID())) {
            return highest;
        }
        int otherAdvance = GeneticsUtil.getGeneticAdvancement(mutationSpecies, exclude, speciesChromosome);
        return otherAdvance > highest ? otherAdvance : highest;
    }
}

