/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.api.recipes.IDescriptiveRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryCraftingForestry;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RecipeUtil {
    public static void addFermenterRecipes(ItemStack resource, int fermentationValue, Fluids output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output.getFluid(1), new FluidStack(FluidRegistry.WATER, 1));
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.JUICE.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.JUICE.getFluid(1));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.FOR_HONEY.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.FOR_HONEY.getFluid(1));
        }
    }

    public static void addFermenterRecipes(String resource, int fermentationValue, Fluids output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output.getFluid(1), new FluidStack(FluidRegistry.WATER, 1));
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.JUICE.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.JUICE.getFluid(1));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.FOR_HONEY.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.FOR_HONEY.getFluid(1));
        }
    }

    @Nullable
    public static InventoryCraftingForestry getCraftRecipe(InventoryCrafting originalCrafting, NonNullList<ItemStack> availableItems, World world, IRecipe recipe) {
        ItemStack output;
        if (!recipe.func_77569_a(originalCrafting, world)) {
            return null;
        }
        ItemStack expectedOutput = recipe.func_77572_b(originalCrafting);
        if (expectedOutput.func_190926_b()) {
            return null;
        }
        InventoryCraftingForestry crafting = new InventoryCraftingForestry();
        NonNullList<ItemStack> stockCopy = ItemStackUtil.condenseStacks(availableItems);
        for (int slot = 0; slot < originalCrafting.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = originalCrafting.func_70301_a(slot);
            if (stackInSlot.func_190926_b()) continue;
            ItemStack equivalent = RecipeUtil.getCraftingEquivalent(stockCopy, originalCrafting, slot, world, recipe, expectedOutput);
            if (equivalent.func_190926_b()) {
                return null;
            }
            crafting.func_70299_a(slot, equivalent);
        }
        if (recipe.func_77569_a((InventoryCrafting)crafting, world) && ItemStack.func_77989_b((ItemStack)(output = recipe.func_77572_b((InventoryCrafting)crafting)), (ItemStack)expectedOutput)) {
            return crafting;
        }
        return null;
    }

    private static ItemStack getCraftingEquivalent(NonNullList<ItemStack> stockCopy, InventoryCrafting crafting, int slot, World world, IRecipe recipe, ItemStack expectedOutput) {
        ItemStack originalStack = crafting.func_70301_a(slot);
        for (ItemStack stockStack : stockCopy) {
            ItemStack output;
            if (stockStack.func_190926_b()) continue;
            ItemStack singleStockStack = ItemStackUtil.createCopyWithCount(stockStack, 1);
            crafting.func_70299_a(slot, singleStockStack);
            if (!recipe.func_77569_a(crafting, world) || !ItemStack.func_77989_b((ItemStack)(output = recipe.func_77572_b(crafting)), (ItemStack)expectedOutput)) continue;
            crafting.func_70299_a(slot, originalStack);
            return stockStack.func_77979_a(1);
        }
        crafting.func_70299_a(slot, originalStack);
        return ItemStack.field_190927_a;
    }

    public static List<IRecipe> findMatchingRecipes(InventoryCrafting inventory, World world) {
        return ForgeRegistries.RECIPES.getValues().stream().filter(recipe -> recipe.func_77569_a(inventory, world)).collect(Collectors.toList());
    }

    public static void addRecipe(String recipeName, Block block, Object ... obj) {
        RecipeUtil.addRecipe(recipeName, new ItemStack(block), obj);
    }

    public static void addRecipe(String recipeName, Item item, Object ... obj) {
        RecipeUtil.addRecipe(recipeName, new ItemStack(item), obj);
    }

    public static void addRecipe(String recipeName, ItemStack itemstack, Object ... obj) {
        ShapedRecipeCustom recipe = new ShapedRecipeCustom(itemstack, obj);
        recipe.setRegistryName("forestry", recipeName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessRecipe(String recipeName, Item item, Object ... obj) {
        RecipeUtil.addShapelessRecipe(recipeName, new ItemStack(item), obj);
    }

    public static void addShapelessRecipe(String recipeName, ItemStack itemstack, Object ... obj) {
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(null, itemstack, obj);
        recipe.setRegistryName("forestry", recipeName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addSmelting(ItemStack res, Item prod, float xp) {
        RecipeUtil.addSmelting(res, new ItemStack(prod), xp);
    }

    public static void addSmelting(ItemStack res, ItemStack prod, float xp) {
        GameRegistry.addSmelting((ItemStack)res, (ItemStack)prod, (float)xp);
    }

    @Nullable
    public static String[][] matches(IDescriptiveRecipe recipe, IInventory inventoryCrafting) {
        NonNullList<NonNullList<ItemStack>> recipeIngredients = recipe.getRawIngredients();
        NonNullList<String> oreDicts = recipe.getOreDicts();
        int width = recipe.getWidth();
        int height = recipe.getHeight();
        return RecipeUtil.matches(recipeIngredients, oreDicts, width, height, inventoryCrafting);
    }

    @Nullable
    public static String[][] matches(NonNullList<NonNullList<ItemStack>> recipeIngredients, NonNullList<String> oreDicts, int width, int height, IInventory inventoryCrafting) {
        ItemStack[][] resources = RecipeUtil.getResources(inventoryCrafting);
        return RecipeUtil.matches(recipeIngredients, oreDicts, width, height, resources);
    }

    public static ItemStack[][] getResources(IInventory inventoryCrafting) {
        ItemStack[][] resources = new ItemStack[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i + j * 3;
                resources[i][j] = inventoryCrafting.func_70301_a(k);
            }
        }
        return resources;
    }

    @Nullable
    public static String[][] matches(NonNullList<NonNullList<ItemStack>> recipeIngredients, NonNullList<String> oreDicts, int width, int height, ItemStack[][] resources) {
        for (int i = 0; i <= 3 - width; ++i) {
            for (int j = 0; j <= 3 - height; ++j) {
                String[][] resourceDicts = RecipeUtil.checkMatch(recipeIngredients, oreDicts, width, height, resources, i, j, true);
                if (resourceDicts != null) {
                    return resourceDicts;
                }
                resourceDicts = RecipeUtil.checkMatch(recipeIngredients, oreDicts, width, height, resources, i, j, false);
                if (resourceDicts == null) continue;
                return resourceDicts;
            }
        }
        return null;
    }

    @Nullable
    private static String[][] checkMatch(NonNullList<NonNullList<ItemStack>> recipeIngredients, NonNullList<String> oreDicts, int width, int height, ItemStack[][] resources, int xInGrid, int yInGrid, boolean mirror) {
        String[][] resourceDicts = new String[3][3];
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack resource = resources[k][l];
                int widthIt = k - xInGrid;
                int heightIt = l - yInGrid;
                NonNullList recipeIngredient = null;
                String oreDict = "";
                if (widthIt >= 0 && heightIt >= 0 && widthIt < width && heightIt < height) {
                    int position = mirror ? width - widthIt - 1 + heightIt * width : widthIt + heightIt * width;
                    recipeIngredient = (NonNullList)recipeIngredients.get(position);
                    oreDict = (String)oreDicts.get(position);
                }
                if (!RecipeUtil.checkIngredientMatch(recipeIngredient, resource)) {
                    return null;
                }
                resourceDicts[k][l] = oreDict;
            }
        }
        return resourceDicts;
    }

    private static boolean checkIngredientMatch(@Nullable NonNullList<ItemStack> recipeIngredient, ItemStack resource) {
        if (recipeIngredient == null || recipeIngredient.isEmpty()) {
            return resource.func_190926_b();
        }
        for (ItemStack item : recipeIngredient) {
            if (!ItemStackUtil.isCraftingEquivalent(item, resource)) continue;
            return true;
        }
        return false;
    }
}

