/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUtil {
    public static void drawItemStack(GuiForestry gui, ItemStack stack, int xPos, int yPos) {
        GuiUtil.drawItemStack(gui.getFontRenderer(), stack, xPos, yPos);
    }

    public static void drawItemStack(FontRenderer fontRenderer, ItemStack stack, int xPos, int yPos) {
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = fontRenderer;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        itemRender.func_180450_b(stack, xPos, yPos);
        itemRender.func_180453_a(font, stack, xPos, yPos, null);
    }

    public static void drawToolTips(GuiForestry gui, ToolTip toolTips, int mouseX, int mouseY) {
        List<String> lines = toolTips.getLines();
        if (!lines.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-gui.getGuiLeft()), (float)(-gui.getGuiTop()), (float)0.0f);
            ScaledResolution scaledresolution = new ScaledResolution(gui.field_146297_k);
            GuiUtils.drawHoveringText(lines, (int)mouseX, (int)mouseY, (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)-1, (FontRenderer)gui.field_146297_k.field_71466_p);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawToolTips(GuiForestry gui, Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip(mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop())) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop());
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            GuiUtil.drawToolTips(gui, tips, mouseX, mouseY);
        }
    }
}

