/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui.widgets;

import forestry.api.climate.IClimateState;
import forestry.api.core.ForestryAPI;
import forestry.core.climate.ClimateStates;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.TextureManagerForestry;
import forestry.greenhouse.gui.GuiGreenhouse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetClimateBar
extends Widget {
    public static final int WIDTH = 90;
    public static final int HEIGHT = 23;
    private final List<ClimateButton> buttons = new ArrayList<ClimateButton>();

    public WidgetClimateBar(WidgetManager manager, int xPos, int yPos) {
        super(manager, xPos, yPos);
        this.width = 90;
        this.height = 23;
        for (EnumClimate climate : EnumClimate.values()) {
            this.buttons.add(new ClimateButton(this, climate, xPos + 5 + climate.ordinal() * 16, yPos + 5));
        }
    }

    @Override
    public void draw(int startX, int startY) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.manager.gui.textureFile);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 0, 202, this.width, this.height);
        for (ClimateButton button : this.buttons) {
            button.draw(startX, startY);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        for (ClimateButton button : this.buttons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            return button.getToolTip();
        }
        return null;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.manager.gui.getGuiLeft();
        mouseY -= this.manager.gui.getGuiTop();
        for (ClimateButton button : this.buttons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            IClimateState climateState = button.climate.climateState;
            ((GuiGreenhouse)this.manager.gui).temperaturePanel.setValue(climateState.getTemperature());
            ((GuiGreenhouse)this.manager.gui).humidityPanel.setValue(climateState.getHumidity());
            ((GuiGreenhouse)this.manager.gui).sendNetworkUpdate();
        }
    }

    @Override
    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        return this.isMouseOver(mouseX -= this.manager.gui.getGuiLeft(), mouseY -= this.manager.gui.getGuiTop());
    }

    protected void drawSprite(TextureAtlasSprite sprite, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureManagerForestry.getInstance().bindGuiTextureMap();
        this.manager.gui.func_175175_a(x, y, sprite, 16, 16);
    }

    private class ClimateButton {
        final WidgetClimateBar parent;
        final EnumClimate climate;
        protected final ToolTip toolTip = new ToolTip(250){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void refresh() {
                ClimateButton.this.toolTip.clear();
                ClimateButton.this.toolTip.add("T: " + ClimateButton.this.climate.climateState.getTemperature());
                ClimateButton.this.toolTip.add("H: " + ClimateButton.this.climate.climateState.getHumidity());
            }
        };
        final int xPos;
        final int yPos;

        public ClimateButton(WidgetClimateBar parent, EnumClimate climate, int xPos, int yPos) {
            this.parent = parent;
            this.climate = climate;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public void draw(int startX, int startY) {
            this.parent.drawSprite(this.climate.getSprite(), startX + this.xPos, startY + this.yPos);
        }

        public ToolTip getToolTip() {
            return this.toolTip;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return mouseX >= this.xPos && mouseX <= this.xPos + 16 && mouseY >= this.yPos && mouseY <= this.yPos + 16;
        }
    }

    private static enum EnumClimate {
        ICY("habitats/snow", Biomes.field_76774_n),
        COLD("habitats/taiga", Biomes.field_76768_g),
        NORMAL("habitats/plains", Biomes.field_76772_c),
        WARM("habitats/jungle", Biomes.field_76782_w),
        HOT("habitats/desert", Biomes.field_76769_d);

        IClimateState climateState;
        String spriteName;

        private EnumClimate(String spriteName, Biome biome) {
            this.climateState = ClimateStates.of(biome.func_185353_n(), biome.func_76727_i());
            this.spriteName = spriteName;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getSprite() {
            return ForestryAPI.textureManager.getDefault(this.spriteName);
        }
    }
}

