/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.gui.GuiHandler;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.blocks.BlockClimatiserSprite;
import forestry.greenhouse.blocks.BlockClimatiserType;
import forestry.greenhouse.blocks.BlockGreenhouseSprite;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.IBlockCamouflaged;
import forestry.greenhouse.blocks.State;
import forestry.greenhouse.tiles.TileDehumidifier;
import forestry.greenhouse.tiles.TileFan;
import forestry.greenhouse.tiles.TileHeater;
import forestry.greenhouse.tiles.TileHumidifier;
import forestry.greenhouse.tiles.TileHygroregulator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockClimatiser
extends Block
implements IBlockWithMeta,
ISpriteRegister,
IItemModelRegister,
IColoredBlock,
IBlockCamouflaged<BlockClimatiser>,
ITileEntityProvider {
    public static final PropertyEnum<BlockClimatiserType> TYPE = PropertyEnum.func_177709_a((String)"type", BlockClimatiserType.class);

    public BlockClimatiser() {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(PluginGreenhouse.getGreenhouseTab());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)BlockClimatiserType.HUMIDIFIER)));
    }

    @Override
    public String getNameFromMeta(int meta) {
        BlockClimatiserType type = BlockClimatiserType.VALUES[meta];
        return type.func_176610_l();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BlockClimatiserType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockClimatiserType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        IActivatable tile = TileUtil.getTile(worldIn, pos, IActivatable.class);
        State state = State.OFF;
        if (tile != null) {
            state = tile.isActive() ? State.ON : State.OFF;
        }
        return super.func_176221_a(blockState, worldIn, pos).func_177226_a(State.PROPERTY, (Comparable)((Object)state));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileForestry tile = TileUtil.getTile((IBlockAccess)world, pos, TileForestry.class);
        if (tile != null && TileUtil.isUsableByPlayer(player, tile)) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (!player.func_70093_af() && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)facing)) {
                return true;
            }
            if (!world.field_72995_K) {
                GuiHandler.openGui(player, tile);
            }
            return true;
        }
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockClimatiserType.VALUES.length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE, State.PROPERTY}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString() + Translator.translateToLocal("tile.for.greenhouse.camouflage.tooltip"));
        } else {
            ItemTooltipUtil.addShiftInformation(stack, world, tooltip, flag);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        BlockClimatiserType type = BlockClimatiserType.VALUES[meta];
        switch (type) {
            case DEHUMIDIFIER: {
                return new TileDehumidifier();
            }
            case HUMIDIFIER: {
                return new TileHumidifier();
            }
            case HYGRO: {
                return new TileHygroregulator();
            }
            case FAN: {
                return new TileFan();
            }
            case HEATER: {
                return new TileHeater();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        Block block;
        if (pos == null || worldIn == null) {
            return 0xFFFFFF;
        }
        ItemStack camouflageStack = this.getCamouflageBlock(worldIn, pos);
        if (tintIndex < 101 && !camouflageStack.func_190926_b() && (block = Block.func_149634_a((Item)camouflageStack.func_77973_b())) != Blocks.field_150350_a) {
            IBlockState camouflageState = block.func_176203_a(camouflageStack.func_77952_i());
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            int color = blockColors.func_186724_a(camouflageState, worldIn, pos, tintIndex);
            if (color != -1) {
                return color;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (int i = 0; i < BlockClimatiserType.VALUES.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation("forestry:climatiser", "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        BlockClimatiserSprite.registerSprites();
    }

    @Override
    public ItemStack getCamouflageBlock(IBlockAccess world, BlockPos pos) {
        ItemStack defaultCamouflageStack;
        ItemStack camouflageStack;
        if (world == null || pos == null) {
            return ItemStack.field_190927_a;
        }
        ICamouflageHandler handler = this.getCamouflageHandler(world, pos);
        if (handler != null && !ItemStackUtil.isIdenticalItem(camouflageStack = handler.getCamouflageBlock(), defaultCamouflageStack = handler.getDefaultCamouflageBlock())) {
            return camouflageStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            return null;
        }
        ICamouflageHandler handler = TileUtil.getTile(world, pos, ICamouflageHandler.class);
        if (handler != null) {
            return handler;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasOverlaySprite(int meta, int layer) {
        return true;
    }

    @Override
    public int getLayers() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDefaultSprite() {
        return BlockGreenhouseSprite.getSprite(BlockGreenhouseType.PLAIN, null, null, -1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getOverlaySprite(EnumFacing facing, IBlockState state, int meta, int layer) {
        return BlockClimatiserSprite.getSprite(BlockClimatiserType.VALUES[meta], facing, state);
    }
}

