/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import forestry.api.recipes.IFermenterRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipe
implements IFermenterRecipe {
    private final ItemStack resource;
    private final String resourceOreName;
    private final int fermentationValue;
    private final float modifier;
    private final Fluid output;
    private final FluidStack fluidResource;

    public FermenterRecipe(ItemStack resource, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        Preconditions.checkNotNull((Object)resource, (Object)"Fermenter Resource cannot be null!");
        Preconditions.checkArgument((!resource.func_190926_b() ? 1 : 0) != 0, (Object)"Fermenter Resource item cannot be empty!");
        Preconditions.checkNotNull((Object)output, (Object)"Fermenter Output cannot be null!");
        Preconditions.checkNotNull((Object)fluidResource, (Object)"Fermenter Liquid cannot be null!");
        this.resource = resource;
        this.resourceOreName = null;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    public FermenterRecipe(String resourceOreName, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        Preconditions.checkNotNull((Object)resourceOreName, (Object)"Fermenter Resource cannot be null!");
        Preconditions.checkArgument((!resourceOreName.isEmpty() ? 1 : 0) != 0, (Object)"Fermenter Resource ore name cannot be empty!");
        Preconditions.checkNotNull((Object)output, (Object)"Fermenter Output cannot be null!");
        Preconditions.checkNotNull((Object)fluidResource, (Object)"Fermenter Liquid cannot be null!");
        this.resource = ItemStack.field_190927_a;
        this.resourceOreName = resourceOreName;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    @Override
    public ItemStack getResource() {
        return this.resource;
    }

    @Override
    @Nullable
    public String getResourceOreName() {
        return this.resourceOreName;
    }

    @Override
    public FluidStack getFluidResource() {
        return this.fluidResource;
    }

    @Override
    public int getFermentationValue() {
        return this.fermentationValue;
    }

    @Override
    public float getModifier() {
        return this.modifier;
    }

    @Override
    public Fluid getOutput() {
        return this.output;
    }

    @Override
    public int compareTo(IFermenterRecipe o) {
        return this.resource.func_190926_b() ? 1 : 0;
    }
}

