/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class World2ObjectMap<O> {
    private static final Set<World2ObjectMap> MAPS = new HashSet<World2ObjectMap>();
    private final Map<Integer, O> delegate = new HashMap<Integer, O>();
    private final Factory factory;
    @Nullable
    private final Listener listener;

    public World2ObjectMap(Factory factory) {
        this(factory, null);
    }

    public World2ObjectMap(Factory factory, @Nullable Listener listener) {
        MAPS.add(this);
        this.factory = factory;
        this.listener = listener;
    }

    @Nullable
    public O get(World world) {
        return this.delegate.get(this.getIndex(world));
    }

    public Collection<O> values() {
        return this.delegate.values();
    }

    private int getIndex(World world) {
        return Integer.hashCode(world.field_73011_w.getDimension()) + Boolean.hashCode(world.field_72995_K);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        for (World2ObjectMap map : MAPS) {
            map.delegate.remove(map.getIndex(world));
            if (map.listener == null) continue;
            map.listener.onWorldStateChange(world, false, (WorldEvent)event);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        for (World2ObjectMap map : MAPS) {
            map.delegate.put(map.getIndex(world), map.factory.createValue(world));
            if (map.listener == null) continue;
            map.listener.onWorldStateChange(world, false, (WorldEvent)event);
        }
    }

    public static interface Listener {
        public void onWorldStateChange(World var1, boolean var2, WorldEvent var3);
    }

    public static interface Factory<O> {
        public O createValue(World var1);
    }
}

