/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import com.mojang.authlib.GameProfile;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.genetics.alleles.Allele;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public abstract class AlleleSpecies
extends Allele
implements IAlleleSpeciesBuilder,
IAlleleSpecies {
    private final String binomial;
    private final String authority;
    private final String description;
    private final IClassification branch;
    private boolean hasEffect = false;
    private boolean isSecret = false;
    private boolean isCounted = true;
    private EnumTemperature climate = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;
    @Nullable
    private Integer complexityOverride = null;

    protected AlleleSpecies(String modId, String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean isDominant, IClassification branch, String binomial) {
        super(modId, uid, unlocalizedName, isDominant);
        this.branch = branch;
        this.binomial = binomial;
        this.description = Translator.translateToLocal(unlocalizedDescription);
        this.authority = authority;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return 0.0f;
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            ItemRegistryApiculture beeItems = PluginApiculture.getItems();
            Item item = itemstack.func_77973_b();
            if (beeItems.honeyDrop == item) {
                return 0.5f;
            }
            if (beeItems.honeydew == item) {
                return 0.7f;
            }
            if (beeItems.beeComb == item) {
                return 0.4f;
            }
        }
        if (this.getRoot().isMember(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry<ItemStack, Float> entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!ItemStackUtil.isIdenticalItem(entry.getKey(), itemstack)) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }

    @Override
    public int getComplexity() {
        if (this.complexityOverride != null) {
            return this.complexityOverride;
        }
        return GeneticsUtil.getResearchComplexity(this, this.getRoot().getSpeciesChromosomeType());
    }

    @Override
    public void setComplexity(int complexity) {
        this.complexityOverride = complexity;
    }

    @Override
    public NonNullList<ItemStack> getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        List<? extends IMutation> allMutations;
        if (world.field_73012_v.nextFloat() < (float)bountyLevel / 16.0f && !(allMutations = this.getRoot().getCombinations(this)).isEmpty()) {
            ArrayList<IMutation> unresearchedMutations = new ArrayList<IMutation>();
            IBreedingTracker tracker = individual.getGenome().getSpeciesRoot().getBreedingTracker(world, researcher);
            for (IMutation iMutation : allMutations) {
                if (tracker.isResearched(iMutation)) continue;
                unresearchedMutations.add(iMutation);
            }
            IMutation chosenMutation = !unresearchedMutations.isEmpty() ? (IMutation)unresearchedMutations.get(world.field_73012_v.nextInt(unresearchedMutations.size())) : allMutations.get(world.field_73012_v.nextInt(allMutations.size()));
            ItemStack itemStack = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, chosenMutation);
            NonNullList bounty = NonNullList.func_191196_a();
            bounty.add((Object)itemStack);
            return bounty;
        }
        return NonNullList.func_191196_a();
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climate;
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public boolean isCounted() {
        return this.isCounted;
    }

    @Override
    public String getBinomial() {
        return this.binomial;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    @Override
    public IAlleleSpeciesBuilder setTemperature(EnumTemperature temperature) {
        this.climate = temperature;
        return this;
    }

    @Override
    public IAlleleSpeciesBuilder setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
        return this;
    }

    @Override
    public IAlleleSpeciesBuilder setHasEffect() {
        this.hasEffect = true;
        return this;
    }

    @Override
    public IAlleleSpeciesBuilder setIsSecret() {
        this.isSecret = true;
        return this;
    }

    @Override
    public IAlleleSpeciesBuilder setIsNotCounted() {
        this.isCounted = false;
        return this;
    }
}

