/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISpeciesType;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.blocks.BlockRegistryArboriculture;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.CheckPollinatableTree;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeAlyzerPlugin;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemRegistryArboriculture;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TreeRoot
extends SpeciesRoot
implements ITreeRoot {
    public static final String UID = "rootTrees";
    private static int treeSpeciesCount = -1;
    @Nullable
    private static ITreekeepingMode activeTreekeepingMode;
    public static final List<ITree> treeTemplates;
    private final Map<IFruitFamily, Collection<IFruitProvider>> providersForFamilies = new HashMap<IFruitFamily, Collection<IFruitProvider>>();
    private final List<ITreekeepingMode> treekeepingModes = new ArrayList<ITreekeepingMode>();
    private static final List<ITreeMutation> treeMutations;
    private final LinkedList<ILeafTickHandler> leafTickHandlers = new LinkedList();

    public TreeRoot() {
        this.setResearchSuitability(new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE), 1.0f);
    }

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return ITree.class;
    }

    @Override
    public int getSpeciesCount() {
        if (treeSpeciesCount < 0) {
            treeSpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleTreeSpecies) || !((IAlleleTreeSpecies)entry.getValue()).isCounted()) continue;
                ++treeSpeciesCount;
            }
        }
        return treeSpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack itemstack) {
        return this.getType(itemstack) != null;
    }

    @Override
    public boolean isMember(ItemStack stack, ISpeciesType type) {
        return this.getType(stack) == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    @Nullable
    public EnumGermlingType getType(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemRegistryArboriculture items = PluginArboriculture.getItems();
        Item item = stack.func_77973_b();
        if (items.sapling == item) {
            return EnumGermlingType.SAPLING;
        }
        if (items.pollenFertile == item) {
            return EnumGermlingType.POLLEN;
        }
        return null;
    }

    @Override
    public EnumGermlingType getIconType() {
        return EnumGermlingType.SAPLING;
    }

    @Override
    public ITree getTree(World world, BlockPos pos) {
        return TileUtil.getResultFromTile((IBlockAccess)world, pos, TileSapling.class, TileTreeContainer::getTree);
    }

    @Override
    @Nullable
    public ITree getMember(ItemStack itemstack) {
        if (!this.isMember(itemstack) || itemstack.func_77978_p() == null) {
            return null;
        }
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    public ITree getMember(NBTTagCompound compound) {
        return new Tree(compound);
    }

    @Override
    public ITree getTree(World world, ITreeGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ItemStack getMemberStack(IIndividual tree, ISpeciesType type) {
        ItemGermlingGE germlingItem;
        Preconditions.checkArgument((boolean)(tree instanceof ITree), (Object)"individual is not a tree");
        Preconditions.checkArgument((boolean)(type instanceof EnumGermlingType), (Object)"type is not an EnumGermlingType");
        ItemRegistryArboriculture items = PluginArboriculture.getItems();
        switch ((EnumGermlingType)type) {
            case SAPLING: {
                germlingItem = items.sapling;
                break;
            }
            case POLLEN: {
                germlingItem = items.pollenFertile;
                break;
            }
            default: {
                throw new RuntimeException("Cannot instantiate a tree of type " + type);
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        tree.writeToNBT(nbttagcompound);
        ItemStack treeStack = new ItemStack((Item)germlingItem);
        treeStack.func_77982_d(nbttagcompound);
        return treeStack;
    }

    @Override
    public boolean plantSapling(World world, ITree tree, GameProfile owner, BlockPos pos) {
        BlockRegistryArboriculture blocks = PluginArboriculture.getBlocks();
        IBlockState state = blocks.saplingGE.func_176223_P().func_177226_a((IProperty)BlockSapling.TREE, (Comparable)tree.getGenome().getPrimary());
        boolean placed = world.func_175656_a(pos, state);
        if (!placed) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (blocks.saplingGE != block) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((IBlockAccess)world, pos, TileSapling.class);
        if (sapling == null) {
            world.func_175698_g(pos);
            return false;
        }
        sapling.setTree(tree.copy());
        sapling.getOwnerHandler().setOwner(owner);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        return true;
    }

    @Override
    public boolean setFruitBlock(World world, ITreeGenome genome, IAlleleFruit allele, float sappiness, BlockPos pos) {
        Block block;
        IBlockState state;
        boolean placed;
        BlockFruitPod fruitPod;
        BlockRegistryArboriculture blocks = PluginArboriculture.getBlocks();
        EnumFacing facing = BlockUtil.getValidPodFacing(world, pos);
        if (facing != null && (fruitPod = blocks.getFruitPod(allele)) != null && (placed = world.func_175656_a(pos, state = fruitPod.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing))) && fruitPod == (block = world.func_180495_p(pos).func_177230_c())) {
            TileFruitPod pod = TileUtil.getTile((IBlockAccess)world, pos, TileFruitPod.class);
            if (pod != null) {
                pod.setProperties(genome, allele, sappiness);
                world.func_175704_b(pos, pos);
                return true;
            }
            world.func_175698_g(pos);
            return false;
        }
        return false;
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public ITree templateAsIndividual(IAllele[] template) {
        return new Tree(this.templateAsGenome(template));
    }

    @Override
    public ITree templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Tree(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IArboristTracker getBreedingTracker(World world, @Nullable GameProfile player) {
        String filename = "ArboristTracker." + (player == null ? "common" : player.getId());
        ArboristTracker tracker = (ArboristTracker)world.func_72943_a(ArboristTracker.class, filename);
        if (tracker == null) {
            tracker = new ArboristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        tracker.setUsername(player);
        tracker.setWorld(world);
        return tracker;
    }

    @Override
    public List<ITreekeepingMode> getTreekeepingModes() {
        return this.treekeepingModes;
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(World world) {
        if (activeTreekeepingMode != null) {
            return activeTreekeepingMode;
        }
        IArboristTracker tracker = this.getBreedingTracker(world, null);
        String modeName = tracker.getModeName();
        ITreekeepingMode mode = this.getTreekeepingMode(modeName);
        Preconditions.checkNotNull((Object)mode);
        this.setTreekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().debug("Set Treekeeping mode for a world to " + mode);
        return activeTreekeepingMode;
    }

    @Override
    public void registerTreekeepingMode(ITreekeepingMode mode) {
        this.treekeepingModes.add(mode);
    }

    @Override
    public void setTreekeepingMode(World world, ITreekeepingMode mode) {
        activeTreekeepingMode = mode;
        this.getBreedingTracker(world, null).setModeName(mode.getName());
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(String name) {
        for (ITreekeepingMode mode : this.treekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().debug("Failed to find a Treekeeping mode called '%s', reverting to fallback.");
        return this.treekeepingModes.get(0);
    }

    @Override
    public List<ITree> getIndividualTemplates() {
        return treeTemplates;
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        treeTemplates.add(new Tree(TreeManager.treeRoot.templateAsGenome(template)));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return TreeDefinition.Oak.getTemplate();
    }

    @Override
    public List<ITreeMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(treeMutations);
        }
        return treeMutations;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        treeMutations.add((ITreeMutation)mutation);
    }

    @Override
    public void registerLeafTickHandler(ILeafTickHandler handler) {
        this.leafTickHandlers.add(handler);
    }

    @Override
    public Collection<ILeafTickHandler> getLeafTickHandlers() {
        return this.leafTickHandlers;
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumTreeChromosome.values();
    }

    @Override
    public IChromosomeType getSpeciesChromosomeType() {
        return EnumTreeChromosome.SPECIES;
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return TreeAlyzerPlugin.INSTANCE;
    }

    @Override
    public ICheckPollinatable createPollinatable(IIndividual individual) {
        Preconditions.checkArgument((boolean)(individual instanceof ITree), (Object)"individual must be a tree");
        return new CheckPollinatableTree((ITree)individual);
    }

    @Override
    @Nullable
    public IPollinatable tryConvertToPollinatable(@Nullable GameProfile owner, World world, BlockPos pos, IIndividual individual) {
        Preconditions.checkArgument((boolean)(individual instanceof ITree), (Object)"pollen must be an instance of ITree");
        ITree pollen = (ITree)individual;
        if (pollen.setLeaves(world, owner, pos)) {
            return TileUtil.getTile((IBlockAccess)world, pos, IPollinatable.class);
        }
        return null;
    }

    @Override
    public Collection<IFruitProvider> getFruitProvidersForFruitFamily(IFruitFamily fruitFamily) {
        if (this.providersForFamilies.isEmpty()) {
            Collection<IAllele> fruitAlleles = AlleleManager.alleleRegistry.getRegisteredAlleles(EnumTreeChromosome.FRUITS);
            for (IAlleleFruit iAlleleFruit : fruitAlleles) {
                IFruitProvider fruitProvider = iAlleleFruit.getProvider();
                Collection fruitProviders = this.providersForFamilies.computeIfAbsent(fruitProvider.getFamily(), k -> new ArrayList());
                fruitProviders.add(fruitProvider);
            }
        }
        return this.providersForFamilies.computeIfAbsent(fruitFamily, k -> new ArrayList());
    }

    static {
        treeTemplates = new ArrayList<ITree>();
        treeMutations = new ArrayList<ITreeMutation>();
    }
}

