/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITree;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IIndividual;
import net.minecraftforge.common.EnumPlantType;

public class CheckPollinatableTree
implements ICheckPollinatable {
    private final ITree tree;

    public CheckPollinatableTree(ITree tree) {
        this.tree = tree;
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.tree.getGenome().getPrimary().getPlantType();
    }

    @Override
    public ITree getPollen() {
        return this.tree;
    }

    @Override
    public boolean canMateWith(IIndividual pollen) {
        return pollen instanceof ITree && this.tree.getMate() == null && !this.tree.isGeneticEqual(pollen);
    }

    @Override
    public boolean isPollinated() {
        return this.tree.getMate() != null;
    }
}

