/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.api.climate.IClimateState;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockStructure;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.blocks.BlockGreenhouseSprite;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.IBlockCamouflaged;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileGreenhouseControl;
import forestry.greenhouse.tiles.TileGreenhouseGearbox;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGreenhouse
extends BlockStructure
implements ISpriteRegister,
IBlockWithMeta,
IColoredBlock,
IBlockCamouflaged<BlockGreenhouse> {
    public static final PropertyEnum<BlockGreenhouseType> TYPE = PropertyEnum.func_177709_a((String)"type", BlockGreenhouseType.class);

    public BlockGreenhouse() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(PluginGreenhouse.getGreenhouseTab());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)BlockGreenhouseType.PLAIN)));
    }

    @Override
    public String getNameFromMeta(int meta) {
        BlockGreenhouseType type = BlockGreenhouseType.VALUES[meta];
        return type.func_176610_l();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (int i = 0; i < BlockGreenhouseType.VALUES.length; ++i) {
            if (i == 1 || i == 2) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse", "inventory"));
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        String validationError;
        if (playerIn.func_70093_af()) {
            return false;
        }
        MultiblockTileEntityForestry part = TileUtil.getTile((IBlockAccess)worldIn, pos, MultiblockTileEntityForestry.class);
        if (part == null) {
            return false;
        }
        IMultiblockController controller = part.getMultiblockLogic().getController();
        ItemStack mainHand = playerIn.func_184614_ca();
        if (mainHand.func_190926_b() && playerIn.func_184592_cb().func_190926_b() && !controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
            long tick = worldIn.func_82737_E();
            if (tick > this.previousMessageTick + 20L) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(validationError));
                this.previousMessageTick = tick;
            }
            return true;
        }
        if (!controller.isAssembled()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            part.openGui(playerIn);
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BlockGreenhouseType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockGreenhouseType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 1 || meta == 2) {
            meta = 0;
        }
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < BlockGreenhouseType.VALUES.length; ++i) {
            if (i == 1 || i == 2) continue;
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add(Translator.translateToLocal("tile.for.greenhouse.tooltip"));
            tooltip.add(TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString() + Translator.translateToLocal("tile.for.greenhouse.camouflage.tooltip"));
        } else {
            ItemTooltipUtil.addShiftInformation(stack, world, tooltip, flag);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return this.getGreenhouseType(state) == BlockGreenhouseType.CONTROL;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        BlockGreenhouseType type = this.getGreenhouseType(this.func_176203_a(meta));
        switch (type) {
            case GEARBOX: {
                return new TileGreenhouseGearbox();
            }
            case CONTROL: {
                return new TileGreenhouseControl();
            }
        }
        return new TileGreenhousePlain();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState blockState, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        Block block;
        if (pos == null || world == null) {
            return 0xFFFFFF;
        }
        ItemStack camouflageStack = this.getCamouflageBlock(world, pos);
        if (tintIndex == 102) {
            BlockGreenhouseType type = this.getGreenhouseType(blockState);
            if (type == BlockGreenhouseType.SCREEN) {
                IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController(world, pos, IGreenhouseComponent.class);
                if (controller == null || !controller.isAssembled()) {
                    return 0xFFFFFF;
                }
                IClimateContainer container = controller.getClimateContainer();
                IClimateState state = container.getState();
                return ClimateUtil.getColor(EnumTemperature.getFromValue(state.getTemperature()));
            }
            if (type == BlockGreenhouseType.BORDER_CENTER) {
                boolean isClosed = true;
                IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController(world, pos, IGreenhouseComponent.class);
                if (controller == null || !controller.isAssembled()) {
                    isClosed = false;
                } else {
                    IGreenhouseProvider manager = controller.getProvider();
                    isClosed = manager.isClosed();
                }
                return isClosed ? 1356406 : 12197655;
            }
        } else if (tintIndex < 101 && !camouflageStack.func_190926_b() && (block = Block.func_149634_a((Item)camouflageStack.func_77973_b())) != Blocks.field_150350_a) {
            IBlockState camouflageState = block.func_176203_a(camouflageStack.func_77952_i());
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            int color = blockColors.func_186724_a(camouflageState, world, pos, tintIndex);
            if (color != -1) {
                return color;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        BlockGreenhouseSprite.registerSprites();
    }

    public BlockGreenhouseType getGreenhouseType(IBlockState state) {
        return (BlockGreenhouseType)((Object)state.func_177229_b(TYPE));
    }

    @Override
    public ItemStack getCamouflageBlock(IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            return ItemStack.field_190927_a;
        }
        TileEntity tile = TileUtil.getTile(world, pos, TileEntity.class);
        if (tile instanceof ICamouflagedTile) {
            ItemStack defaultCamouflageStack;
            ICamouflageHandler tileHandler;
            ItemStack tileCamouflageStack;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            ItemStack camouflageStack = ItemStack.field_190927_a;
            if (tile instanceof ICamouflageHandler && !ItemStackUtil.isIdenticalItem(tileCamouflageStack = (tileHandler = (ICamouflageHandler)tile).getCamouflageBlock(), defaultCamouflageStack = tileHandler.getDefaultCamouflageBlock())) {
                camouflageStack = tileCamouflageStack;
            }
            if (camouflageStack.func_190926_b() && tile instanceof IMultiblockComponent) {
                IMultiblockComponent component = (IMultiblockComponent)tile;
                IMultiblockController controller = component.getMultiblockLogic().getController();
                if (controller instanceof ICamouflageHandler) {
                    ICamouflageHandler multiblockHandler = (ICamouflageHandler)((Object)controller);
                    camouflageStack = multiblockHandler.getCamouflageBlock();
                }
                if (!controller.isAssembled()) {
                    camouflageStack = ItemStack.field_190927_a;
                }
            }
            return camouflageStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
        TileEntity tile = TileUtil.getTile(world, pos, TileEntity.class);
        if (tile instanceof ICamouflagedTile) {
            IMultiblockComponent component;
            IMultiblockController controller;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            ICamouflageHandler handler = null;
            if (tile instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)tile;
            }
            if ((handler == null || handler.getCamouflageBlock().func_190926_b()) && tile instanceof IMultiblockComponent && (controller = (component = (IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)controller);
            }
            return handler;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasOverlaySprite(int meta, int layer) {
        BlockGreenhouseType type = BlockGreenhouseType.VALUES[meta];
        return layer == 0 || type.twoLayers;
    }

    @Override
    public int getLayers() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDefaultSprite() {
        return BlockGreenhouseSprite.getSprite(BlockGreenhouseType.PLAIN, null, null, -1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getOverlaySprite(EnumFacing facing, IBlockState state, int meta, int layer) {
        return BlockGreenhouseSprite.getSprite(BlockGreenhouseType.VALUES[meta], facing, state, layer);
    }
}

