/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.PluginCore;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicArboreal
extends FarmLogicHomogeneous {
    private final Map<BlockPos, Integer> lastExtentsHarvest = new HashMap<BlockPos, Integer>();

    public FarmLogicArboreal(ItemStack resource, IBlockState ground, Collection<IFarmable> germlings) {
        super(resource, ground, germlings);
    }

    public FarmLogicArboreal() {
        super(new ItemStack(Blocks.field_150346_d), PluginCore.getBlocks().humus.func_176223_P(), FarmRegistry.getInstance().getFarmables("farmArboreal"));
    }

    @Override
    public String getName() {
        return "Managed Arboretum";
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Blocks.field_150345_g);
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(10.0f * hydrationModifier);
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        NonNullList products = this.produce;
        this.produce = this.collectEntityItems(world, farmHousing, true);
        return products;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.lastExtentsHarvest.containsKey(pos)) {
            this.lastExtentsHarvest.put(pos, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        Collection<ICrop> crops = this.harvestBlocks(world, position);
        this.lastExtentsHarvest.put(pos, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> harvestBlocks(World world, BlockPos position) {
        IFarmable farmable = FarmLogicArboreal.getFarmableForBlock(world, position, this.farmables);
        if (farmable == null) {
            return Collections.emptyList();
        }
        Stack<BlockPos> knownCropPositions = new Stack<BlockPos>();
        knownCropPositions.add(position);
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        while (!knownCropPositions.empty()) {
            BlockPos knownCropPos = (BlockPos)knownCropPositions.pop();
            for (BlockPos candidate : BlockPos.func_177980_a((BlockPos)knownCropPos.func_177982_a(-1, -1, -1), (BlockPos)knownCropPos.func_177982_a(1, 1, 1))) {
                if (checkedBlocks.contains(candidate)) continue;
                checkedBlocks.add(candidate);
                IBlockState blockState = world.func_180495_p(candidate);
                ICrop crop = farmable.getCropAt(world, candidate, blockState);
                if (crop == null) continue;
                crops.push(crop);
                knownCropPositions.push(candidate);
            }
        }
        return crops;
    }

    @Nullable
    private static IFarmable getFarmableForBlock(World world, BlockPos position, Collection<IFarmable> farmables) {
        IBlockState blockState = world.func_180495_p(position);
        for (IFarmable farmable : farmables) {
            ICrop crop = farmable.getCropAt(world, position, blockState);
            if (crop == null) continue;
            return farmable;
        }
        return null;
    }

    @Override
    protected boolean maintainGermlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPosition;
            IBlockState soilState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            if (!world.func_175623_d(position) || !this.isAcceptedSoil(soilState = world.func_180495_p(soilPosition = position.func_177977_b()))) continue;
            return this.plantSapling(world, farmHousing, position);
        }
        return false;
    }

    private boolean plantSapling(World world, IFarmHousing farmHousing, BlockPos position) {
        Collections.shuffle(this.farmables);
        for (IFarmable candidate : this.farmables) {
            if (!farmHousing.plantGermling(candidate, world, position)) continue;
            return true;
        }
        return false;
    }
}

