/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.items.ICraftingPlan;
import forestry.core.network.PacketBufferForestry;
import forestry.core.recipes.RecipePair;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.gui.ContainerFabricator;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.inventory.InventoryFabricator;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFabricator
extends TilePowered
implements ISlotPickupWatcher,
ILiquidTankTile,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    private final InventoryAdapterTile craftingInventory;
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int meltingPoint = 0;

    public TileFabricator() {
        super(1100, 3300);
        this.setEnergyPerWorkCycle(200);
        this.craftingInventory = new InventoryGhostCrafting<TileFabricator>(this, 9);
        this.setInternalInventory(new InventoryFabricator(this));
        this.moltenTank = new FilteredTank(8000, false, false).setFilters(Fluids.GLASS.getFluid());
        this.tankManager = new TankManager(this, this.moltenTank);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heat", this.heat);
        this.tankManager.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("Heat");
        this.tankManager.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && this.heat < this.getMeltingPoint() - 100) {
            this.moltenTank.drain(5, true);
        }
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.func_70301_a(0);
        if (smeltResource.func_190926_b()) {
            return;
        }
        IFabricatorSmeltingRecipe smelt = FabricatorSmeltingRecipeManager.findMatchingSmelting(smeltResource);
        if (smelt == null || smelt.getMeltingPoint() > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.fillInternal(smeltFluid, false) == smeltFluid.amount) {
            this.func_70298_a(0, 1);
            this.moltenTank.fillInternal(smeltFluid, true);
            this.meltingPoint = smelt.getMeltingPoint();
        }
    }

    @Override
    public boolean workCycle() {
        this.heat += 100;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        this.craftResult();
        return true;
    }

    @Nullable
    private RecipePair getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.func_70301_a(1);
        FluidStack liquid = this.moltenTank.getFluid();
        RecipePair<IFabricatorRecipe> recipePair = FabricatorRecipeManager.findMatchingRecipe(plan, (IInventory)this.craftingInventory);
        IFabricatorRecipe recipe = recipePair.getRecipe();
        if (liquid != null && recipe != null && !liquid.containsFluid(recipe.getLiquid())) {
            return RecipePair.EMPTY;
        }
        return recipePair;
    }

    public ItemStack getResult(RecipePair<IFabricatorRecipe> myRecipePair) {
        IFabricatorRecipe myRecipe = myRecipePair.getRecipe();
        if (myRecipe == null) {
            return ItemStack.field_190927_a;
        }
        return myRecipe.getRecipeOutput().func_77946_l();
    }

    @Override
    public void onTake(int slotIndex, EntityPlayer player) {
        if (slotIndex == 2) {
            this.func_70298_a(2, 1);
        }
    }

    private void craftResult() {
        RecipePair myRecipePair = this.getRecipe();
        ItemStack craftResult = this.getResult(myRecipePair);
        IFabricatorRecipe myRecipe = (IFabricatorRecipe)myRecipePair.getRecipe();
        if (myRecipe != null && !craftResult.func_190926_b() && this.func_70301_a(2).func_190926_b()) {
            FluidStack drained;
            FluidStack liquid = myRecipe.getLiquid();
            NonNullList<ItemStack> crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
            if (this.removeFromInventory(crafting, myRecipePair, false) && (drained = this.moltenTank.drainInternal(liquid, false)) != null && drained.isFluidStackIdentical(liquid)) {
                Item planItem;
                this.removeFromInventory(crafting, myRecipePair, true);
                this.moltenTank.drain(liquid.amount, true);
                if (!this.func_70301_a(1).func_190926_b() && (planItem = this.func_70301_a(1).func_77973_b()) instanceof ICraftingPlan) {
                    ItemStack planUsed = ((ICraftingPlan)planItem).planUsed(this.func_70301_a(1), craftResult);
                    this.func_70299_a(1, planUsed);
                }
                this.func_70299_a(2, craftResult);
            }
        }
    }

    private boolean removeFromInventory(NonNullList<ItemStack> set, RecipePair<IFabricatorRecipe> recipePair, boolean doRemove) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 3, 18);
        return InventoryUtil.removeSets((IInventory)inventory, 1, set, recipePair.getOreDictEntries(), null, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        boolean hasRecipe = true;
        boolean hasLiquidResources = true;
        boolean hasResources = true;
        ItemStack plan = this.func_70301_a(1);
        RecipePair<IFabricatorRecipe> recipePair = FabricatorRecipeManager.findMatchingRecipe(plan, (IInventory)this.craftingInventory);
        if (!recipePair.isEmpty()) {
            IFabricatorRecipe recipe = recipePair.getRecipe();
            NonNullList<ItemStack> crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
            hasResources = this.removeFromInventory(crafting, recipePair, false);
            FluidStack toDrain = recipe.getLiquid();
            FluidStack drained = this.moltenTank.drainInternal(toDrain, false);
            hasLiquidResources = drained != null && drained.isFluidStackIdentical(toDrain);
        } else {
            hasRecipe = false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasResources, EnumErrorCode.NO_RESOURCE_INVENTORY);
        return hasRecipe;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        if (!this.func_70301_a(0).func_190926_b()) {
            IFabricatorSmeltingRecipe smelt = FabricatorSmeltingRecipeManager.findMatchingSmelting(this.func_70301_a(0));
            if (smelt != null) {
                return smelt.getMeltingPoint();
            }
        } else if (this.moltenTank.getFluidAmount() > 0) {
            return this.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    public void getGUINetworkData(int i, int j) {
        if (i == 0) {
            this.heat = j;
        } else if (i == 1) {
            this.meltingPoint = j;
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        iCrafting.func_71112_a(container, 0, this.heat);
        iCrafting.func_71112_a(container, 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiFabricator(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerFabricator(player.field_71071_by, this);
    }
}

