/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fabricator;

import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.render.ForestryResource;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeCategory
extends ForestryRecipeCategory<FabricatorRecipeWrapper> {
    private static final int planSlot = 0;
    private static final int smeltingInputSlot = 1;
    private static final int craftOutputSlot = 2;
    private static final int craftInputSlot = 3;
    private static final int inputTank = 0;
    private static final ResourceLocation guiTexture = new ForestryResource("textures/gui/fabricator.png");
    private final ICraftingGridHelper craftingGridHelper;

    public FabricatorRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 20, 16, 136, 54), "tile.for.fabricator.name");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(3, 2);
    }

    public String getUid() {
        return "forestry.fabricator";
    }

    public void setRecipe(IRecipeLayout recipeLayout, FabricatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 118, 0);
        guiItemStacks.init(1, true, 5, 4);
        guiItemStacks.init(2, false, 118, 36);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 3 + x + y * 3;
                guiItemStacks.init(index, true, 46 + x * 18, y * 18);
            }
        }
        guiFluidStacks.init(0, true, 6, 32, 16, 16, 2000, false, null);
        IFabricatorRecipe recipe = (IFabricatorRecipe)recipeWrapper.getRecipe();
        ItemStack plan = recipe.getPlan();
        if (!plan.func_190926_b()) {
            guiItemStacks.set(0, plan);
        }
        ArrayList<ItemStack> smeltingInput = new ArrayList<ItemStack>();
        Fluid recipeFluid = recipe.getLiquid().getFluid();
        for (IFabricatorSmeltingRecipe s : FabricatorRecipeCategory.getSmeltingInputs().get(recipeFluid)) {
            smeltingInput.add(s.getResource());
        }
        if (!smeltingInput.isEmpty()) {
            guiItemStacks.set(1, smeltingInput);
        }
        List itemOutputs = ingredients.getOutputs(ItemStack.class);
        guiItemStacks.set(2, (List)itemOutputs.get(0));
        List itemStackInputs = ingredients.getInputs(ItemStack.class);
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, itemStackInputs, recipe.getWidth(), recipe.getHeight());
        List fluidInputs = ingredients.getInputs(FluidStack.class);
        if (!fluidInputs.isEmpty()) {
            guiFluidStacks.set(0, (List)fluidInputs.get(0));
        }
    }

    private static Map<Fluid, List<IFabricatorSmeltingRecipe>> getSmeltingInputs() {
        HashMap<Fluid, List<IFabricatorSmeltingRecipe>> smeltingInputs = new HashMap<Fluid, List<IFabricatorSmeltingRecipe>>();
        for (IFabricatorSmeltingRecipe smelting : FabricatorSmeltingRecipeManager.recipes) {
            Fluid fluid = smelting.getProduct().getFluid();
            if (!smeltingInputs.containsKey(fluid)) {
                smeltingInputs.put(fluid, new ArrayList());
            }
            ((List)smeltingInputs.get(fluid)).add(smelting);
        }
        return smeltingInputs;
    }
}

