/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketErrorUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final IErrorLogic errorLogic;

    public PacketErrorUpdate(TileEntity tile, IErrorLogicSource errorLogicSource) {
        this.pos = tile.func_174877_v();
        this.errorLogic = errorLogicSource.getErrorLogic();
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        this.errorLogic.writeData(data);
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.ERROR_UPDATE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            TileUtil.actOnTile((IBlockAccess)player.field_70170_p, pos, IErrorLogicSource.class, errorSourceTile -> {
                IErrorLogic errorLogic = errorSourceTile.getErrorLogic();
                errorLogic.readData(data);
            });
        }
    }
}

