/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IModelManager;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrated
extends ItemForestry
implements IColoredItem {
    private final ItemStack contained;
    @Nullable
    private final String oreDictName;

    public ItemCrated(ItemStack contained, @Nullable String oreDictName) {
        this.contained = contained;
        this.oreDictName = oreDictName;
    }

    public ItemStack getContained() {
        return this.contained;
    }

    @Nullable
    public String getOreDictName() {
        return this.oreDictName;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (this.contained.func_190926_b() || heldItem.func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)heldItem);
            }
            heldItem.func_190918_g(1);
            ItemStack dropStack = this.contained.func_77946_l();
            dropStack.func_190920_e(9);
            ItemStackUtil.dropItemStackAsEntity(dropStack, worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 40);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (this.contained.func_190926_b()) {
            return Translator.translateToLocal("item.for.crate.name");
        }
        String containedName = this.contained.func_82833_r();
        return Translator.translateToLocalFormatted("for.item.crated.grammar", containedName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        if (this.contained.func_190926_b()) {
            manager.registerItemModel(item, 0);
            manager.registerItemModel(item, 1, "crate-filled");
        } else {
            ModelResourceLocation modelLocation = new ModelResourceLocation("forestry:crate-filled", "crate-filled");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelLocation);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{modelLocation});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int renderPass) {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        if (this.contained.func_190926_b() || renderPass == 100) {
            return -1;
        }
        int color = colors.func_186728_a(this.contained, renderPass);
        if (color != -1) {
            return color;
        }
        return -1;
    }
}

