/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.apiculture.genetics.Bee;
import forestry.core.inventory.ItemInventory;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemInventoryImprinter
extends ItemInventory {
    private static final short specimenSlot = 0;
    private static final short imprintedSlot = 1;
    private int primaryIndex = 0;
    private int secondaryIndex = 0;

    public ItemInventoryImprinter(EntityPlayer player, ItemStack itemStack) {
        super(player, 2, itemStack);
    }

    public void advancePrimary() {
        this.primaryIndex = this.primaryIndex < BeeManager.beeRoot.getIndividualTemplates().size() - 1 ? ++this.primaryIndex : 0;
    }

    public void advanceSecondary() {
        this.secondaryIndex = this.secondaryIndex < BeeManager.beeRoot.getIndividualTemplates().size() - 1 ? ++this.secondaryIndex : 0;
    }

    public void regressPrimary() {
        this.primaryIndex = this.primaryIndex > 0 ? --this.primaryIndex : BeeManager.beeRoot.getIndividualTemplates().size() - 1;
    }

    public void regressSecondary() {
        this.secondaryIndex = this.secondaryIndex > 0 ? --this.secondaryIndex : BeeManager.beeRoot.getIndividualTemplates().size() - 1;
    }

    public IAlleleBeeSpecies getPrimary() {
        return BeeManager.beeRoot.getIndividualTemplates().get(this.primaryIndex).getGenome().getPrimary();
    }

    public IAlleleBeeSpecies getSecondary() {
        return BeeManager.beeRoot.getIndividualTemplates().get(this.secondaryIndex).getGenome().getPrimary();
    }

    public IBee getSelectedBee() {
        IBeeRoot beeRoot = BeeManager.beeRoot;
        List<IBee> individualTemplates = beeRoot.getIndividualTemplates();
        Map<String, IAllele[]> genomeTemplates = beeRoot.getGenomeTemplates();
        IAllele[] templateActive = genomeTemplates.get(individualTemplates.get(this.primaryIndex).getIdent());
        IAllele[] templateInactive = genomeTemplates.get(individualTemplates.get(this.secondaryIndex).getIdent());
        IBeeGenome genome = beeRoot.templateAsGenome(templateActive, templateInactive);
        return new Bee(genome);
    }

    public int getPrimaryIndex() {
        return this.primaryIndex;
    }

    public int getSecondaryIndex() {
        return this.secondaryIndex;
    }

    public void setPrimaryIndex(int index) {
        this.primaryIndex = index;
    }

    public void setSecondaryIndex(int index) {
        this.secondaryIndex = index;
    }

    @Override
    public void onSlotClick(int slotIndex, EntityPlayer player) {
        ItemStack specimen = this.func_70301_a(0);
        if (specimen.func_190926_b()) {
            return;
        }
        if (!BeeManager.beeRoot.isMember(specimen)) {
            return;
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            return;
        }
        IBee imprint = this.getSelectedBee();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        imprint.writeToNBT(nbttagcompound);
        specimen.func_77982_d(nbttagcompound);
        this.func_70299_a(1, specimen);
        this.func_70299_a(0, ItemStack.field_190927_a);
    }

    @Override
    public String func_70005_c_() {
        return "Imprinter";
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return BeeManager.beeRoot.isMember(itemStack);
    }
}

