package forestry.plugins.compat;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Constants;
import forestry.core.fluids.Fluids;
import forestry.farming.logic.FarmableDoubleCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.ForestryPluginUids;

@ForestryPlugin(pluginID = ForestryPluginUids.BETTER_WITH_MODS, name = "Better With Mods", author = "Nedelosk", url = Constants.URL, unlocalizedDescription = "for.plugin.betterwithmods.description")
public class PluginBetterWithMods extends CompatPlugin {
	public PluginBetterWithMods() {
		super("Better With Mods", "betterwithmods");
	}

	@Override
	public void registerRecipes() {
		IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
		int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
		PropertyBool TOP = PropertyBool.func_177716_a("top");
		PropertyInteger AGE = BlockCrops.field_176488_a;
		ItemStack hempSeed = getItemStack("hemp");
		Block hempCrop = getBlock("hemp");

		if (hempSeed != null && hempCrop != null) {
			IBlockState defaultState = hempCrop.func_176223_P();
			IBlockState planted = defaultState.func_177226_a(AGE, 0).func_177226_a(TOP, false);
			IBlockState mature = defaultState.func_177226_a(AGE, 7).func_177226_a(TOP, false);
			IBlockState topMature = defaultState.func_177226_a(AGE, 7).func_177226_a(TOP, true);

			farmRegistry.registerFarmables("farmWheat", new FarmableDoubleCrop(hempSeed, planted, mature, topMature, false));
			farmRegistry.registerFarmables("farmOrchard", new FarmableDoubleCrop(hempSeed, planted, mature, topMature, true));

			RecipeManagers.squeezerManager.addRecipe(10, hempSeed, Fluids.SEED_OIL.getFluid(seedAmount));
		}
	}
}
