/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.base.Joiner;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.IForestryPlugin;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.Set;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;

public class ForestryModEnvWarningCallable
implements ICrashCallable {
    private final String disabledModulesMessage;

    public static void register() {
        Set<IForestryPlugin> configDisabledPlugins = PluginManager.configDisabledPlugins;
        if (!configDisabledPlugins.isEmpty()) {
            ArrayList<String> disabledPluginNames = new ArrayList<String>();
            for (IForestryPlugin plugin : configDisabledPlugins) {
                ForestryPlugin info = plugin.getClass().getAnnotation(ForestryPlugin.class);
                disabledPluginNames.add(info.name());
            }
            String disabledModulesMessage = "Plugins have been disabled in the config: " + Joiner.on((String)", ").join(disabledPluginNames);
            ForestryModEnvWarningCallable callable = new ForestryModEnvWarningCallable(disabledModulesMessage);
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        }
    }

    private ForestryModEnvWarningCallable(String disabledModulesMessage) {
        this.disabledModulesMessage = disabledModulesMessage;
    }

    public String call() {
        return this.disabledModulesMessage;
    }

    public String getLabel() {
        return "forestry ";
    }
}

