/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationBuilder;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.api.genetics.IAllele;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.JubilanceProviderHermit;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.core.PluginCore;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.text.WordUtils;

public enum BeeDefinition implements IBeeDefinition
{
    FOREST(BeeBranchDefinition.HONEY, "nigrocincta", true, new Color(1691884), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FERTILITY, EnumAllele.Fertility.HIGH);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    MEADOWS(BeeBranchDefinition.HONEY, "florea", true, new Color(15667998), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.SLOWER);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    COMMON(BeeBranchDefinition.HONEY, "cerana", true, new Color(0xB2B2B2), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.35f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition hiveBee0 : overworldHiveBees) {
                for (BeeDefinition hiveBee1 : overworldHiveBees) {
                    if (hiveBee0.ordinal() >= hiveBee1.ordinal()) continue;
                    this.registerMutation(hiveBee0, hiveBee1, 15);
                }
            }
        }
    }
    ,
    CULTIVATED(BeeBranchDefinition.HONEY, "mellifera", true, new Color(5715180), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.4f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.FAST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition hiveBee : overworldHiveBees) {
                this.registerMutation(COMMON, hiveBee, 12);
            }
        }
    }
    ,
    NOBLE(BeeBranchDefinition.NOBLE, "nobilis", false, new Color(15505945), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.DRIPPING, 1), Float.valueOf(0.2f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(COMMON, CULTIVATED, 10);
        }
    }
    ,
    MAJESTIC(BeeBranchDefinition.NOBLE, "regalis", true, new Color(0x7F0000), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.DRIPPING, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FERTILITY, EnumAllele.Fertility.MAXIMUM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NOBLE, CULTIVATED, 8);
        }
    }
    ,
    IMPERIAL(BeeBranchDefinition.NOBLE, "imperatorius", false, new Color(10739759), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.DRIPPING, 1), Float.valueOf(0.2f)).addProduct(PluginApiculture.getItems().royalJelly.getItemStack(), Float.valueOf(0.15f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectBeatific);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NOBLE, MAJESTIC, 8);
        }
    }
    ,
    DILIGENT(BeeBranchDefinition.INDUSTRIOUS, "sedulus", false, new Color(12720620), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.2f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(COMMON, CULTIVATED, 10);
        }
    }
    ,
    UNWEARY(BeeBranchDefinition.INDUSTRIOUS, "assiduus", true, new Color(1698906), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTENED);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DILIGENT, CULTIVATED, 8);
        }
    }
    ,
    INDUSTRIOUS(BeeBranchDefinition.INDUSTRIOUS, "industria", false, new Color(0xFFFFFF), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.2f)).addProduct(PluginApiculture.getItems().pollenCluster.get(EnumPollenCluster.NORMAL, 1), Float.valueOf(0.15f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.FAST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DILIGENT, UNWEARY, 8);
        }
    }
    ,
    STEADFAST(BeeBranchDefinition.HEROIC, "legio", false, new Color(5057301), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.COCOA, 1), Float.valueOf(0.2f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.CAVE_DWELLING, true);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    VALIANT(BeeBranchDefinition.HEROIC, "centurio", true, new Color(6450141), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.COCOA, 1), Float.valueOf(0.3f)).addSpecialty(new ItemStack(Items.field_151102_aT), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.CAVE_DWELLING, true);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    HEROIC(BeeBranchDefinition.HEROIC, "kraphti", false, new Color(11785700), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.COCOA, 1), Float.valueOf(0.4f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectHeroic);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(STEADFAST, VALIANT, 6).restrictBiomeType(BiomeDictionary.Type.FOREST);
        }
    }
    ,
    SINISTER(BeeBranchDefinition.INFERNAL, "caecus", false, new Color(11785700), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.45f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectAggressive);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition parent2 : EnumSet.of(MODEST, TROPICAL)) {
                this.registerMutation(CULTIVATED, parent2, 60).restrictBiomeType(BiomeDictionary.Type.NETHER);
            }
        }
    }
    ,
    FIENDISH(BeeBranchDefinition.INFERNAL, "diabolus", true, new Color(14139109), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.55f)).addProduct(PluginCore.getItems().ash.getItemStack(), Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectAggressive);
        }

        @Override
        protected void registerMutations() {
            for (BeeDefinition parent2 : EnumSet.of(CULTIVATED, MODEST, TROPICAL)) {
                this.registerMutation(SINISTER, parent2, 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
            }
        }
    }
    ,
    DEMONIC(BeeBranchDefinition.INFERNAL, "draco", false, new Color(16049152), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.45f)).addProduct(new ItemStack(Items.field_151114_aO), Float.valueOf(0.15f)).setHasEffect().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectIgnition);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SINISTER, FIENDISH, 25).restrictBiomeType(BiomeDictionary.Type.NETHER);
        }
    }
    ,
    MODEST(BeeBranchDefinition.AUSTERE, "modicus", false, new Color(12959366), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.PARCHED, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    FRUGAL(BeeBranchDefinition.AUSTERE, "permodestus", true, new Color(15260849), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.PARCHED, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONG);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MODEST, SINISTER, 16).restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH).restrictHumidity(EnumHumidity.ARID);
            this.registerMutation(MODEST, FIENDISH, 10).restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH).restrictHumidity(EnumHumidity.ARID);
        }
    }
    ,
    AUSTERE(BeeBranchDefinition.AUSTERE, "correpere", false, new Color(16775874), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.PARCHED, 1), Float.valueOf(0.2f)).addSpecialty(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.POWDERY, 1), Float.valueOf(0.5f)).setHasEffect().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectCreeper);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MODEST, FRUGAL, 8).restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH).restrictHumidity(EnumHumidity.ARID);
        }
    }
    ,
    TROPICAL(BeeBranchDefinition.TROPICAL, "mendelia", false, new Color(3637280), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SILKY, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    EXOTIC(BeeBranchDefinition.TROPICAL, "darwini", true, new Color(3164419), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SILKY, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONG);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(AUSTERE, TROPICAL, 12);
        }
    }
    ,
    EDENIC(BeeBranchDefinition.TROPICAL, "humboldti", false, new Color(3751181), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SILKY, 1), Float.valueOf(0.2f)).setHasEffect().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectExploration);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(EXOTIC, TROPICAL, 8);
        }
    }
    ,
    ENDED(BeeBranchDefinition.END, "notchi", false, new Color(14711290), new Color(0xD9DE9E)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    SPECTRAL(BeeBranchDefinition.END, "idolum", true, new Color(11111405), new Color(0xD9DE9E)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.5f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectReanimation);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(HERMITIC, ENDED, 4);
        }
    }
    ,
    PHANTASMAL(BeeBranchDefinition.END, "lemur", false, new Color(13369594), new Color(0xD9DE9E)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.4f)).setHasEffect().setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONGEST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectResurrection);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SPECTRAL, ENDED, 2);
        }
    }
    ,
    WINTRY(BeeBranchDefinition.FROZEN, "brumalis", false, new Color(10551240), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FERTILITY, EnumAllele.Fertility.MAXIMUM);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    ICY(BeeBranchDefinition.FROZEN, "coagulis", true, new Color(0xA0FFFF), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.2f)).addProduct(PluginCore.getItems().craftingMaterial.getIceShard(1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(INDUSTRIOUS, WINTRY, 12).restrictTemperature(EnumTemperature.ICY, EnumTemperature.COLD);
        }
    }
    ,
    GLACIAL(BeeBranchDefinition.FROZEN, "glacialis", false, new Color(0xEFFFFF), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.2f)).addProduct(PluginCore.getItems().craftingMaterial.getIceShard(1), Float.valueOf(0.4f)).setTemperature(EnumTemperature.ICY).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(ICY, WINTRY, 8).restrictTemperature(EnumTemperature.ICY, EnumTemperature.COLD);
        }
    }
    ,
    VINDICTIVE(BeeBranchDefinition.VENGEFUL, "ultio", false, new Color(15400947), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.IRRADIATED, 1), Float.valueOf(0.25f)).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.NORMAL);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MONASTIC, DEMONIC, 4).setIsSecret();
        }
    }
    ,
    VENGEFUL(BeeBranchDefinition.VENGEFUL, "punire", false, new Color(12770816), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.IRRADIATED, 1), Float.valueOf(0.4f)).setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONGER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DEMONIC, VINDICTIVE, 8).setIsSecret();
            this.registerMutation(MONASTIC, VINDICTIVE, 8).setIsSecret();
        }
    }
    ,
    AVENGING(BeeBranchDefinition.VENGEFUL, "hostimentum", false, new Color(0xDDFF00), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.IRRADIATED, 1), Float.valueOf(0.4f)).setHasEffect().setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.LIFESPAN, EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(VENGEFUL, VINDICTIVE, 4);
        }
    }
    ,
    LEPORINE(BeeBranchDefinition.FESTIVE, "lepus", false, new Color(0xFEFF8F), new Color(3987287)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.SILKY, 1), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151110_aK), Float.valueOf(0.1f)).setHasEffect().setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectFestiveEaster);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MEADOWS, FOREST, 10).restrictDateRange(3, 29, 4, 15).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    MERRY(BeeBranchDefinition.FESTIVE, "feliciter", false, new Color(0xFFFFFF), new Color(0xD40000)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.3f)).addProduct(PluginCore.getItems().craftingMaterial.getIceShard(1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.ICY).setHasEffect().setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectSnowing);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(WINTRY, FOREST, 10).restrictDateRange(12, 21, 12, 27).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    TIPSY(BeeBranchDefinition.FESTIVE, "ebrius", false, new Color(0xFFFFFF), new Color(12720620)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.FROZEN, 1), Float.valueOf(0.3f)).addProduct(PluginCore.getItems().craftingMaterial.getIceShard(1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.ICY).setHasEffect().setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectDrunkard);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(WINTRY, MEADOWS, 10).restrictDateRange(12, 27, 1, 2).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    TRICKY(BeeBranchDefinition.FESTIVE, "libita", false, new Color(4800827), new Color(16738816)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.4f)).addProduct(new ItemStack(Items.field_151106_aX), Float.valueOf(0.15f)).addSpecialty(new ItemStack(Items.field_151144_bL, 1, 0), Float.valueOf(0.02f)).addSpecialty(new ItemStack(Items.field_151144_bL, 1, 2), Float.valueOf(0.02f)).addSpecialty(new ItemStack(Items.field_151144_bL, 1, 3), Float.valueOf(0.02f)).addSpecialty(new ItemStack(Items.field_151144_bL, 1, 4), Float.valueOf(0.02f)).setHasEffect().setIsNotCounted();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWER_PROVIDER, EnumAllele.Flowers.GOURD);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SINISTER, COMMON, 10).restrictDateRange(10, 15, 11, 3).setIsSecret();
        }

        @Override
        protected boolean isSecret() {
            return true;
        }
    }
    ,
    RURAL(BeeBranchDefinition.AGRARIAN, "rustico", false, new Color(0xFEFF8F), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.2f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MEADOWS, DILIGENT, 12).restrictBiomeType(BiomeDictionary.Type.PLAINS);
        }
    }
    ,
    FARMERLY(BeeBranchDefinition.AGRARIAN, "arator", true, new Color(13866792), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.27f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TERRITORY, EnumAllele.Territory.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(RURAL, UNWEARY, 10).restrictBiomeType(BiomeDictionary.Type.PLAINS);
        }
    }
    ,
    AGRARIAN(BeeBranchDefinition.AGRARIAN, "arator", true, new Color(16763509), new Color(16769095)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.35f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.SPEED, EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectFertile);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TERRITORY, EnumAllele.Territory.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(FARMERLY, INDUSTRIOUS, 6).restrictBiomeType(BiomeDictionary.Type.PLAINS);
        }
    }
    ,
    MARSHY(BeeBranchDefinition.BOGGY, "adorasti", true, new Color(5531174), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.3f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    MIRY(BeeBranchDefinition.BOGGY, "humidium", true, new Color(9613122), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.36f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FERTILITY, EnumAllele.Fertility.MAXIMUM);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MARSHY, NOBLE, 15).restrictTemperature(EnumTemperature.WARM).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    BOGGY(BeeBranchDefinition.BOGGY, "paluster", true, new Color(6916424), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.39f)).addSpecialty(PluginCore.getItems().peat.getItemStack(), Float.valueOf(0.08f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectMycophilic);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.TERRITORY, EnumAllele.Territory.LARGER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MARSHY, MIRY, 9).restrictTemperature(EnumTemperature.WARM).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    MONASTIC(BeeBranchDefinition.MONASTIC, "monachus", false, new Color(4339484), new Color(16775094)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.WHEATEN, 1), Float.valueOf(0.3f)).addSpecialty(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MELLOW, 1), Float.valueOf(0.1f)).setJubilanceProvider(new JubilanceProviderHermit());
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    SECLUDED(BeeBranchDefinition.MONASTIC, "contractus", true, new Color(8087092), new Color(16775094)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addSpecialty(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MELLOW, 1), Float.valueOf(0.2f)).setJubilanceProvider(new JubilanceProviderHermit());
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.FASTEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MONASTIC, AUSTERE, 12);
        }
    }
    ,
    HERMITIC(BeeBranchDefinition.MONASTIC, "anachoreta", false, new Color(16766060), new Color(16775094)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addSpecialty(PluginApiculture.getItems().beeComb.get(EnumHoneyComb.MELLOW, 1), Float.valueOf(0.2f)).setJubilanceProvider(new JubilanceProviderHermit()).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.FLOWERING, EnumAllele.Flowering.FASTEST);
            AlleleHelper.getInstance().set(template, EnumBeeChromosome.EFFECT, AlleleEffects.effectRepulsion);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MONASTIC, SECLUDED, 8);
        }
    };

    private static final EnumSet<BeeDefinition> overworldHiveBees;
    private final BeeBranchDefinition branch;
    private final IAlleleBeeSpecies species;
    @Nullable
    private IAllele[] template;
    @Nullable
    private IBeeGenome genome;

    private BeeDefinition(BeeBranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String uid = "forestry." + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        IAlleleBeeSpeciesBuilder speciesBuilder = BeeManager.beeFactory.createSpecies(uid, dominant, "Sengir", name, description, branch.getBranch(), binomial, primary.getRGB(), secondary.getRGB());
        if (this.isSecret()) {
            speciesBuilder.setIsSecret();
        }
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesBuilder var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    protected boolean isSecret() {
        return false;
    }

    public static void initBees() {
        for (BeeDefinition bee : BeeDefinition.values()) {
            bee.init();
        }
        for (BeeDefinition bee : BeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    public static void preInit() {
        MinecraftForge.EVENT_BUS.post(new AlleleSpeciesRegisterEvent<IAlleleBeeSpecies>(BeeManager.beeRoot, IAlleleBeeSpecies.class));
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.getInstance().set(this.template, EnumBeeChromosome.SPECIES, this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationBuilder registerMutation(BeeDefinition parent1, BeeDefinition parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1.species, parent2.species, this.getTemplate(), chance);
    }

    @Override
    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    @Override
    public final IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack(bee, beeType);
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist(this);
    }

    static {
        overworldHiveBees = EnumSet.of(FOREST, new BeeDefinition[]{MARSHY, MEADOWS, MODEST, TROPICAL, WINTRY});
    }
}

