/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.tiles;

import forestry.api.greenhouse.DefaultGreenhouseListener;
import forestry.api.greenhouse.IGreenhouseListener;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IGreenhouseController;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileGreenhouseControl extends TileGreenhouse implements IGreenhouseComponent.Listener {

	private final IGreenhouseListener greenhouseListener;

	public TileGreenhouseControl() {
		this.greenhouseListener = new ControlGreenhouseListener(this);
	}

	@Override
	public IGreenhouseListener getGreenhouseListener() {
		return greenhouseListener;
	}

	private static class ControlGreenhouseListener extends DefaultGreenhouseListener {
		private final TileGreenhouseControl tile;

		public ControlGreenhouseListener(TileGreenhouseControl tile) {
			this.tile = tile;
		}

		@Override
		public boolean canWork(IGreenhouseController greenhouse, boolean canWork) {
			return canWork && !hasRedstoneSignal();
		}

		private boolean hasRedstoneSignal() {
			for (EnumFacing direction : EnumFacing.field_82609_l) {
				BlockPos side = tile.func_174877_v().func_177972_a(direction);
				EnumFacing dir = direction.func_176734_d();
				World world = tile.func_145831_w();
				if (world.func_175651_c(side, dir) > 0 || world.func_175627_a(side, dir) > 0) {
					return true;
				}
			}
			return false;
		}
	}

}
