/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.items;

import forestry.core.items.ItemBlockForestry;
import forestry.greenhouse.blocks.BlockGreenhouseDoor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockGreenhouseDoor extends ItemBlockForestry<BlockGreenhouseDoor> {

	public ItemBlockGreenhouseDoor(BlockGreenhouseDoor block) {
		super(block);
	}

	/**
	 * Copied from {@link ItemDoor#onItemUse(EntityPlayer, World, BlockPos, EnumHand, EnumFacing, float, float, float)}
	 */
	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if (facing != EnumFacing.UP) {
			return EnumActionResult.FAIL;
		} else {
			IBlockState iblockstate = worldIn.func_180495_p(pos);
			Block block = iblockstate.func_177230_c();

			if (!block.func_176200_f(worldIn, pos)) {
				pos = pos.func_177972_a(facing);
			}

			ItemStack itemstack = player.func_184586_b(hand);

			if (player.func_175151_a(pos, facing, itemstack) && this.field_150939_a.func_176196_c(worldIn, pos)) {
				EnumFacing enumfacing = EnumFacing.func_176733_a(player.field_70177_z);
				int i = enumfacing.func_82601_c();
				int j = enumfacing.func_82599_e();
				boolean flag = i < 0 && hitZ < 0.5F || i > 0 && hitZ > 0.5F || j < 0 && hitX > 0.5F || j > 0 && hitX < 0.5F;
				ItemDoor.func_179235_a(worldIn, pos, enumfacing, this.field_150939_a, flag);
				SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, player);
				worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
				itemstack.func_190918_g(1);
				return EnumActionResult.SUCCESS;
			} else {
				return EnumActionResult.FAIL;
			}
		}
	}
}
