/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.PluginCore;

public class BlockResourceOre extends Block implements IItemModelRegister, IBlockWithMeta {
	public static final PropertyEnum<EnumResourceType> ORE_RESOURCES = PropertyEnum.func_177708_a("resource", EnumResourceType.class, input -> input != null && input.hasOre());

	public BlockResourceOre() {
		super(Material.field_151576_e);
		func_149711_c(3F);
		func_149752_b(5F);
		func_149647_a(CreativeTabForestry.tabForestry);
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ORE_RESOURCES, EnumResourceType.APATITE));
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, ORE_RESOURCES);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(ORE_RESOURCES).getMeta();
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(ORE_RESOURCES, EnumResourceType.VALUES[meta]);
	}

	@Override
	public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
		super.func_180653_a(world, pos, state, chance, fortune);

		if (state.func_177229_b(ORE_RESOURCES) == EnumResourceType.APATITE) {
			this.func_180637_b(world, pos, MathHelper.func_76136_a(world.field_73012_v, 1, 4));
		}
	}
	
	@Override
	public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		EnumResourceType type = state.func_177229_b(ORE_RESOURCES);
		switch (type) {
			case APATITE: {
				int fortuneModifier = RANDOM.nextInt(fortune + 2) - 1;
				if (fortuneModifier < 0) {
					fortuneModifier = 0;
				}

				int amount = (2 + RANDOM.nextInt(5)) * (fortuneModifier + 1);
				if (amount > 0) {
					drops.add(PluginCore.getItems().apatite.getItemStack(amount));
				}
				break;
			}
			case TIN: {
				drops.add(new ItemStack(this, 1, func_180651_a(state)));
				break;
			}
			case COPPER: {
				drops.add(new ItemStack(this, 1, func_180651_a(state)));
				break;
			}
		}
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (EnumResourceType resourceType : ORE_RESOURCES.func_177700_c()) {
			list.add(get(resourceType, 1));
		}
	}

	/* MODLES */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0, "ores/apatite");
		manager.registerItemModel(item, 1, "ores/copper");
		manager.registerItemModel(item, 2, "ores/tin");
	}

	public ItemStack get(EnumResourceType type, int amount) {
		return new ItemStack(this, amount, type.getMeta());
	}

	@Override
	public String getNameFromMeta(int meta) {
		EnumResourceType resourceType = func_176203_a(meta).func_177229_b(ORE_RESOURCES);
		return resourceType.func_176610_l();
	}
}
