/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.IClimatePosition;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ClimateUtil;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileBeeHousingBase
extends TileBase
implements IBeeHousing,
IOwnedTile,
IClimatised,
IGuiBeeHousingDelegate,
IStreamableGui {
    private final String hintKey;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final IBeekeepingLogic beeLogic;
    private int breedingProgressPercent = 0;

    protected TileBeeHousingBase(String hintKey) {
        this.hintKey = hintKey;
        this.beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    }

    @Override
    public String getHintKey() {
        return this.hintKey;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
        this.ownerHandler.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
        this.ownerHandler.readFromNBT(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.beeLogic.writeToNBT(updateTag);
        this.ownerHandler.writeToNBT(updateTag);
        return updateTag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.beeLogic.readFromNBT(tag);
        this.ownerHandler.readFromNBT(tag);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.field_145850_b, this.func_174877_v());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return ClimateUtil.getTemperature(this.field_145850_b, this.func_174877_v());
    }

    @Override
    public float getExactHumidity() {
        return ClimateUtil.getHumidity(this.field_145850_b, this.func_174877_v());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                TileBeeHousingBase.doPollenFX(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doPollenFX(World world, double xCoord, double yCoord, double zCoord) {
        double fxX = xCoord + 0.5;
        double fxY = yCoord + 0.25;
        double fxZ = zCoord + 0.5;
        float distanceFromCenter = 0.6f;
        float leftRightSpreadFromCenter = distanceFromCenter * (world.field_73012_v.nextFloat() - 0.5f);
        float upSpread = world.field_73012_v.nextFloat() * 6.0f / 16.0f;
        ParticleRender.addEntityHoneyDustFX(world, fxX - (double)distanceFromCenter, fxY += (double)upSpread, fxZ + (double)leftRightSpreadFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)distanceFromCenter, fxY, fxZ + (double)leftRightSpreadFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ - (double)distanceFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ + (double)distanceFromCenter);
    }

    @Override
    public void updateServerSide() {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        data.func_150787_b(this.beeLogic.getBeeProgressPercent());
        IClimatePosition position = ForestryAPI.climateManager.getPosition(this.field_145850_b, this.func_174877_v());
        if (position != null) {
            ClimateUtil.writePositionData(position, data);
        }
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.breedingProgressPercent = data.func_150792_a();
        IClimatePosition position = ForestryAPI.climateManager.getPosition(this.field_145850_b, this.func_174877_v());
        if (position != null) {
            ClimateUtil.readPositionData(position, data);
        }
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_180494_b(this.func_174877_v());
    }

    @Override
    public int getBlockLightValue() {
        return this.field_145850_b.func_175671_l(this.func_174877_v().func_177984_a());
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.field_145850_b.func_175710_j(this.func_174877_v().func_177984_a());
    }

    @Override
    public boolean isRaining() {
        return this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a());
    }

    @Override
    public GameProfile getOwner() {
        return this.getOwnerHandler().getOwner();
    }

    @Override
    public Vec3d getBeeFXCoordinates() {
        return new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
    }
}

