/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IFruitFamily;
import forestry.core.utils.Translator;

public enum EnumFruitFamily implements IFruitFamily
{
    PRUNES("prunes", "Prunus domestica"),
    POMES("pomes", "Pomum"),
    JUNGLE("jungle", "Tropicus"),
    NUX("nuts", "Nux"),
    NONE("none", "None");

    private final String uid;
    private final String scientific;

    private EnumFruitFamily(String uid, String scientific) {
        this.uid = uid;
        this.scientific = scientific;
        AlleleManager.alleleRegistry.registerFruitFamily(this);
    }

    @Override
    public String getUID() {
        return "forestry." + this.uid;
    }

    @Override
    public String getScientific() {
        return this.scientific;
    }

    @Override
    public String getName() {
        return Translator.translateToLocal("for.family." + this.uid);
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal("for.family." + this.uid + ".description");
    }
}

