/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.network.packets.PacketChipsetClick;
import forestry.core.network.packets.PacketSocketUpdate;
import forestry.core.network.packets.PacketSolderingIronClick;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;

public class ContainerSocketedHelper<T extends TileEntity & ISocketable> implements IContainerSocketed {

	private final T tile;

	public ContainerSocketedHelper(T tile) {
		this.tile = tile;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void handleChipsetClick(int slot) {
		NetworkUtil.sendToServer(new PacketChipsetClick(slot));
	}

	@Override
	public void handleChipsetClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
		if (!tile.getSocket(slot).func_190926_b()) {
			return;
		}

		if (!ChipsetManager.circuitRegistry.isChipset(itemstack)) {
			return;
		}

		ICircuitBoard circuitBoard = ChipsetManager.circuitRegistry.getCircuitBoard(itemstack);
		if (circuitBoard == null) {
			return;
		}

		if (!tile.getSocketType().equals(circuitBoard.getSocketType())) {
			return;
		}

		ItemStack toSocket = itemstack.func_77946_l();
		toSocket.func_190920_e(1);
		tile.setSocket(slot, toSocket);

		ItemStack stack = player.field_71071_by.func_70445_o();
		stack.func_190918_g(1);
		player.func_71113_k();

		PacketSocketUpdate packet = new PacketSocketUpdate(tile);
		NetworkUtil.sendToPlayer(packet, player);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void handleSolderingIronClick(int slot) {
		NetworkUtil.sendToServer(new PacketSolderingIronClick(slot));
	}

	@Override
	public void handleSolderingIronClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
		ItemStack socket = tile.getSocket(slot);
		if (socket.func_190926_b() || !(itemstack.func_77973_b() instanceof ISolderingIron)) {
			return;
		}

		InventoryUtil.stowInInventory(socket, player.field_71071_by, true);
		// Not sufficient space in player's inventory. failed to stow.
		if (!socket.func_190926_b()) {
			return;
		}

		tile.setSocket(slot, ItemStack.field_190927_a);
		itemstack.func_77972_a(1, player);
		player.func_71113_k();

		PacketSocketUpdate packet = new PacketSocketUpdate(tile);
		NetworkUtil.sendToPlayer(packet, player);
	}
}
