/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.PluginCore;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ModUtil;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.natura", name="Natura", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.natura.description")
public class PluginNatura
extends BlankForestryPlugin {
    private static final String NATURA = "Natura";
    @Nullable
    private static Block logNatura;
    @Nullable
    private static Block logWillow;
    @Nullable
    private static Block leavesNatura;
    @Nullable
    private static Block saplingNatura;
    @Nullable
    private static Block saplingNaturaRare;
    private static ItemStack berryBlight;
    private static ItemStack berryDusk;
    private static ItemStack berrySky;
    private static ItemStack berrySting;
    private static ItemStack berryRasp;
    private static ItemStack berryBlue;
    private static ItemStack berryBlack;
    private static ItemStack berryMalo;
    private static ItemStack itemBarley;

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(NATURA);
    }

    @Override
    public String getFailMessage() {
        return "Natura not found";
    }

    @Override
    public void preInit() {
        super.preInit();
        logNatura = PluginNatura.getBlock("tree");
        logWillow = PluginNatura.getBlock("willow");
        leavesNatura = PluginNatura.getBlock("floraleaves");
        saplingNatura = PluginNatura.getBlock("florasapling");
        saplingNaturaRare = PluginNatura.getBlock("Rare Sapling");
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplingNatura != null) {
            saplingItemKeys.add("florasapling");
        }
        if (saplingNaturaRare != null) {
            saplingItemKeys.add("Rare Sapling");
        }
        for (String key : saplingItemKeys) {
            ItemStack saplingWild = PluginNatura.getItemStack(key, Short.MAX_VALUE);
            if (saplingWild.func_190926_b()) continue;
            RecipeUtil.addFermenterRecipes(saplingWild, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
            String saplingName = ItemStackUtil.getItemNameFromRegistryAsString(saplingWild.func_77973_b());
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
        berryBlight = PluginNatura.getItemStack("berry.nether", 0);
        berryDusk = PluginNatura.getItemStack("berry.nether", 1);
        berrySky = PluginNatura.getItemStack("berry.nether", 2);
        berrySting = PluginNatura.getItemStack("berry.nether", 3);
        berryRasp = PluginNatura.getItemStack("berry", 0);
        berryBlue = PluginNatura.getItemStack("berry", 1);
        berryBlack = PluginNatura.getItemStack("berry", 2);
        berryMalo = PluginNatura.getItemStack("berry", 3);
        itemBarley = PluginNatura.getItemStack("barleyFood", 0);
    }

    @Override
    public void registerCrates() {
        Item taintedSoil;
        Item heatSand;
        Item darkTree;
        Item bloodWood;
        Item glowShroom;
        ItemStack potashApple;
        super.registerCrates();
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        if (!berryBlight.func_190926_b()) {
            crateRegistry.registerCrate(berryBlight);
        }
        if (!berryDusk.func_190926_b()) {
            crateRegistry.registerCrate(berryDusk);
        }
        if (!berrySky.func_190926_b()) {
            crateRegistry.registerCrate(berrySky);
        }
        if (!berrySting.func_190926_b()) {
            crateRegistry.registerCrate(berrySting);
        }
        if (!berryRasp.func_190926_b()) {
            crateRegistry.registerCrate(berryRasp);
        }
        if (!berryBlue.func_190926_b()) {
            crateRegistry.registerCrate(berryBlue);
        }
        if (!berryBlack.func_190926_b()) {
            crateRegistry.registerCrate(berryBlack);
        }
        if (!berryMalo.func_190926_b()) {
            crateRegistry.registerCrate(berryMalo);
        }
        if (!itemBarley.func_190926_b()) {
            crateRegistry.registerCrate(itemBarley);
        }
        if (saplingNatura != null) {
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 0));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 1));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 2));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 3));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 4));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 5));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 6));
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 7));
        }
        if (saplingNaturaRare != null) {
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 0));
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 1));
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 2));
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 3));
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 4));
        }
        if (!(potashApple = PluginNatura.getItemStack("Natura.netherfood", 0)).func_190926_b()) {
            crateRegistry.registerCrate(potashApple);
        }
        if ((glowShroom = PluginNatura.getItem("Glowshroom")) != null) {
            crateRegistry.registerCrate(new ItemStack(glowShroom, 1, 0));
            crateRegistry.registerCrate(new ItemStack(glowShroom, 1, 1));
            crateRegistry.registerCrate(new ItemStack(glowShroom, 1, 2));
        }
        if (logNatura != null) {
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 0));
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 1));
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 2));
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 3));
        }
        if (logWillow != null) {
            crateRegistry.registerCrate(new ItemStack(logWillow, 1, 0));
        }
        if ((bloodWood = PluginNatura.getItem("bloodwood")) != null) {
            crateRegistry.registerCrate(new ItemStack(bloodWood, 1, 0));
        }
        if ((darkTree = PluginNatura.getItem("Dark Tree")) != null) {
            crateRegistry.registerCrate(new ItemStack(darkTree, 1, 0));
            crateRegistry.registerCrate(new ItemStack(darkTree, 1, 1));
        }
        if ((heatSand = PluginNatura.getItem("heatsand")) != null) {
            crateRegistry.registerCrate(new ItemStack(heatSand, 1, 0));
        }
        if ((taintedSoil = PluginNatura.getItem("soil.tainted")) != null) {
            crateRegistry.registerCrate(new ItemStack(taintedSoil, 1, 0));
        }
    }

    @Override
    public void registerRecipes() {
        ItemStack seedBarley;
        int amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        Item seed = PluginNatura.getItem("barley.seed");
        if (seed != null) {
            seedBarley = new ItemStack(seed, 1, 0);
            ItemStack seedCotton = new ItemStack(seed, 1, 1);
            ArrayList<ItemStack> seedList = new ArrayList<ItemStack>();
            if (!seedBarley.func_190926_b()) {
                seedList.add(seedBarley);
                RecipeManagers.moistenerManager.addRecipe(seedBarley, new ItemStack((Block)Blocks.field_150391_bh), 5000);
            }
            if (!seedCotton.func_190926_b()) {
                seedList.add(seedCotton);
            }
            for (ItemStack aSeedList : seedList) {
                RecipeManagers.squeezerManager.addRecipe(10, aSeedList, Fluids.SEED_OIL.getFluid(amount));
            }
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            seedBarley = PluginNatura.getBlock("N Crops");
        }
        ArrayList<ItemStack> berries = new ArrayList<ItemStack>();
        if (!berryBlight.func_190926_b()) {
            berries.add(berryBlight);
        }
        if (!berryDusk.func_190926_b()) {
            berries.add(berryDusk);
        }
        if (!berrySky.func_190926_b()) {
            berries.add(berrySky);
        }
        if (!berrySting.func_190926_b()) {
            berries.add(berrySting);
        }
        if (!berryRasp.func_190926_b()) {
            berries.add(berryRasp);
        }
        if (!berryBlue.func_190926_b()) {
            berries.add(berryBlue);
        }
        if (!berryBlack.func_190926_b()) {
            berries.add(berryBlack);
        }
        if (!berryMalo.func_190926_b()) {
            berries.add(berryMalo);
        }
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 2;
        amount = Math.max(amount, 1);
        ItemStack netherFood = PluginNatura.getItemStack("Natura.netherfood", 0);
        ItemStack mulch = PluginCore.getItems().mulch.getItemStack();
        RecipeManagers.squeezerManager.addRecipe(10, netherFood, Fluids.JUICE.getFluid(amount), mulch, ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple"));
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        amount = Math.max(amount, 1);
        for (ItemStack berry : berries) {
            RecipeManagers.squeezerManager.addRecipe(3, berry, Fluids.JUICE.getFluid(amount));
        }
        if (!itemBarley.func_190926_b()) {
            RecipeUtil.addFermenterRecipes(itemBarley, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            int compostWheatAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
            if (compostWheatAmount > 0) {
                ItemStack compostWheat = PluginCore.getItems().fertilizerBio.getItemStack(compostWheatAmount);
                RecipeUtil.addRecipe(compostWheat, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), itemBarley);
            }
            FuelManager.moistenerResource.put(itemBarley, new MoistenerFuel(itemBarley, PluginCore.getItems().mouldyWheat.getItemStack(), 0, 300));
        }
    }

    @Nullable
    private static Block getBlock(String blockName) {
        ResourceLocation key = new ResourceLocation(NATURA, blockName);
        if (ForgeRegistries.BLOCKS.containsKey(key)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(key);
        }
        return null;
    }

    @Nullable
    private static Item getItem(String itemName) {
        ResourceLocation key = new ResourceLocation(NATURA, itemName);
        if (ForgeRegistries.ITEMS.containsKey(key)) {
            return (Item)ForgeRegistries.ITEMS.getValue(key);
        }
        return null;
    }

    private static ItemStack getItemStack(String itemName, int meta) {
        ResourceLocation key = new ResourceLocation(NATURA, itemName);
        if (ForgeRegistries.ITEMS.containsKey(key)) {
            return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(key), 1, meta);
        }
        return ItemStack.field_190927_a;
    }

    static {
        berryBlight = ItemStack.field_190927_a;
        berryDusk = ItemStack.field_190927_a;
        berrySky = ItemStack.field_190927_a;
        berrySting = ItemStack.field_190927_a;
        berryRasp = ItemStack.field_190927_a;
        berryBlue = ItemStack.field_190927_a;
        berryBlack = ItemStack.field_190927_a;
        berryMalo = ItemStack.field_190927_a;
        itemBarley = ItemStack.field_190927_a;
    }
}

