/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.IErrorLogic;
import forestry.core.circuits.ISocketable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileEngine;
import forestry.energy.gui.ContainerEngineElectric;
import forestry.energy.gui.GuiEngineElectric;
import forestry.energy.inventory.InventoryEngineElectric;
import forestry.plugins.compat.PluginIC2;
import ic2.api.energy.prefab.BasicSink;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEngineElectric
extends TileEngine
implements ISocketable,
IInventory,
IStreamableGui {
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final EuConfig euConfig = new EuConfig();
    private BasicSink ic2EnergySink;

    public TileEngineElectric() {
        super("engine.tin", 3000, 100000);
        this.setInternalInventory(new InventoryEngineElectric(this));
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySink = new BasicSink((TileEntity)this, (double)this.euConfig.euStorage, 4);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.func_145839_a(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.readFromNBT(nbttagcompound);
        }
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.writeToNBT(nbttagcompound);
        }
        this.sockets.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    public void onChunkUnload() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.invalidate();
        }
        super.func_145843_s();
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.isRedstoneActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.isRedstoneActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.energyManager.getEnergyStored() / (double)this.energyManager.getMaxEnergyStored() > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void updateServerSide() {
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition(this.ic2EnergySink == null, EnumErrorCode.NO_ENERGY_NET)) {
            return;
        }
        this.ic2EnergySink.update();
        super.updateServerSide();
        if (this.forceCooldown) {
            return;
        }
        if (this.func_70301_a(0) != null) {
            this.replenishFromBattery(0);
        }
        if (!this.updateOnInterval(80)) {
            return;
        }
        boolean canUseEnergy = this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
        errorLogic.setCondition(!canUseEnergy, EnumErrorCode.NO_FUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (!this.isRedstoneActivated()) {
            return;
        }
        if (this.ic2EnergySink.useEnergy((double)this.euConfig.euForCycle)) {
            this.currentOutput = this.euConfig.rfPerCycle;
            this.energyManager.generateEnergy(this.euConfig.rfPerCycle);
        }
    }

    private void replenishFromBattery(int slot) {
        if (!this.isRedstoneActivated()) {
            return;
        }
        this.ic2EnergySink.discharge(this.func_70301_a(slot), (double)(this.euConfig.euForCycle * 3));
    }

    @Override
    protected boolean isBurning() {
        return this.mayBurn() && this.ic2EnergySink != null && this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
    }

    public int getStorageScaled(int i) {
        if (this.ic2EnergySink == null) {
            return 0;
        }
        return Math.min(i, (int)(this.ic2EnergySink.getEnergyStored() * (double)i / this.ic2EnergySink.getCapacity()));
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        this.sockets.writeData(data);
        boolean hasIc2EnergySink = this.ic2EnergySink != null;
        data.writeBoolean(hasIc2EnergySink);
        if (hasIc2EnergySink) {
            data.func_150787_b((int)this.ic2EnergySink.getEnergyStored());
        }
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
        boolean hasIc2EnergySink = data.readBoolean();
        if (hasIc2EnergySink) {
            int energyStored = data.func_150792_a();
            this.ic2EnergySink.setEnergyStored((double)energyStored);
        }
    }

    public void changeEnergyConfig(int euChange, int rfChange, int storageChange) {
        this.euConfig.euForCycle += euChange;
        this.euConfig.rfPerCycle += rfChange;
        this.euConfig.euStorage += storageChange;
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.setCapacity((double)this.euConfig.euStorage);
        }
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitBoard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.ELECTRIC_ENGINE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiEngineElectric(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerEngineElectric(player.field_71071_by, this);
    }

    protected static class EuConfig {
        public int euForCycle = 5;
        public int rfPerCycle = 20;
        public int euStorage = 10;
    }
}

