/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.EscritoireGameBoard;
import forestry.core.tiles.EscritoireGameToken;
import java.io.IOException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EscritoireGame
implements INbtWritable,
INbtReadable,
IStreamable {
    private static final Random rand = new Random();
    public static final int BOUNTY_MAX = 16;
    private EscritoireGameBoard gameBoard;
    private long lastUpdate;
    private int bountyLevel;
    private Status status = Status.EMPTY;

    public EscritoireGame() {
        this.gameBoard = new EscritoireGameBoard();
    }

    @Nullable
    public EscritoireGameToken getToken(int index) {
        return this.gameBoard.getToken(index);
    }

    public Status getStatus() {
        return this.status;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("bountyLevel", this.bountyLevel);
        nbttagcompound.func_74772_a("lastUpdate", this.lastUpdate);
        this.gameBoard.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Status", this.status.ordinal());
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.bountyLevel = nbt.func_74762_e("bountyLevel");
        this.lastUpdate = nbt.func_74763_f("lastUpdate");
        this.gameBoard = new EscritoireGameBoard(nbt);
        if (nbt.func_74764_b("Status")) {
            int statusOrdinal = nbt.func_74762_e("Status");
            this.status = Status.values()[statusOrdinal];
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInt(this.bountyLevel);
        this.gameBoard.writeData(data);
        data.writeEnum(this.status, Status.VALUES);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.bountyLevel = data.readInt();
        this.gameBoard.readData(data);
        this.status = (Status)data.readEnum(Status.VALUES);
    }

    public void initialize(ItemStack specimen) {
        if (this.gameBoard.initialize(specimen)) {
            this.status = Status.PLAYING;
            this.bountyLevel = 16;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public void probe(ItemStack specimen, IInventory inventory, int startSlot, int slotCount) {
        if (this.status != Status.PLAYING) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return;
        }
        if (this.bountyLevel > 1) {
            --this.bountyLevel;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        this.gameBoard.hideProbedTokens();
        int revealCount = this.getSampleSize(slotCount);
        for (int i = 0; i < revealCount; ++i) {
            ItemStack sample = inventory.func_70298_a(startSlot + i, 1);
            if (sample.func_190926_b() || !(rand.nextFloat() < species.getResearchSuitability(sample))) continue;
            this.gameBoard.probe();
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void reset() {
        this.bountyLevel = 16;
        this.gameBoard.reset();
        this.status = Status.EMPTY;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void choose(int tokenIndex) {
        if (this.getStatus() != Status.PLAYING) {
            return;
        }
        EscritoireGameToken token = this.gameBoard.getToken(tokenIndex);
        if (token != null) {
            this.status = this.gameBoard.choose(token);
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public int getBountyLevel() {
        return this.bountyLevel;
    }

    public int getSampleSize(int slotCount) {
        if (this.status == Status.EMPTY) {
            return 0;
        }
        int samples = this.gameBoard.getTokenCount() / 4;
        samples = Math.max(samples, 2);
        return Math.min(samples, slotCount);
    }

    public static enum Status {
        EMPTY,
        PLAYING,
        FAILURE,
        SUCCESS;

        public static final Status[] VALUES;

        static {
            VALUES = Status.values();
        }
    }
}

