/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.gui.ContainerCamouflageSprayCan;
import forestry.core.inventory.ItemInventoryCamouflageSprayCan;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCamouflageSelectClient;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketCamouflageSelectServer
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final ItemStack camouflageStack;
    private final String camouflageType;
    private final CamouflageSelectionType selectionType;

    public PacketCamouflageSelectServer(ICamouflageHandler handler, String camouflageType, CamouflageSelectionType selectionType) {
        this.pos = handler.getCoordinates();
        this.camouflageStack = handler.getCamouflageBlock(camouflageType);
        this.selectionType = selectionType;
        this.camouflageType = camouflageType;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.CAMOUFLAGE_SELECTION;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeShort(this.selectionType.ordinal());
        data.func_180714_a(this.camouflageType);
        data.func_150788_a(this.camouflageStack);
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            ContainerCamouflageSprayCan container;
            ItemInventoryCamouflageSprayCan itemInventoryCamouflageSprayCan;
            BlockPos pos = data.func_179259_c();
            CamouflageSelectionType selectionType = CamouflageSelectionType.values()[data.readShort()];
            String camouflageType = data.readString();
            ItemStack camouflageStack = data.func_150791_c();
            TileEntity tile = TileUtil.getTile((IBlockAccess)player.field_70170_p, pos);
            ICamouflageHandler handler = null;
            if (selectionType == CamouflageSelectionType.MULTIBLOCK) {
                IMultiblockController controller;
                if (tile instanceof IMultiblockComponent && (controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler) {
                    handler = (ICamouflageHandler)((Object)controller);
                }
            } else if (selectionType == CamouflageSelectionType.TILE) {
                if (tile instanceof ICamouflageHandler) {
                    handler = (ICamouflageHandler)tile;
                }
            } else if (player.field_71070_bA instanceof ContainerCamouflageSprayCan && !(itemInventoryCamouflageSprayCan = (ItemInventoryCamouflageSprayCan)(container = (ContainerCamouflageSprayCan)player.field_71070_bA).getItemInventory()).func_191420_l()) {
                handler = itemInventoryCamouflageSprayCan;
            }
            if (handler != null && handler.setCamouflageBlock(camouflageType, camouflageStack, true) && selectionType != CamouflageSelectionType.ITEM) {
                NetworkUtil.sendNetworkPacket(new PacketCamouflageSelectClient(handler, camouflageType, selectionType), pos, player.field_70170_p);
            }
        }
    }
}

