/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.config.Config;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHoneyComb
extends ItemForestry
implements IColoredItem {
    public ItemHoneyComb() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(Tabs.tabApiculture);
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (int i = 0; i < EnumHoneyComb.VALUES.length; ++i) {
            manager.registerItemModel(item, i, "beecombs/" + EnumHoneyComb.get((int)i).name);
        }
    }

    public String func_77667_c(ItemStack stack) {
        EnumHoneyComb honeyComb = EnumHoneyComb.get(stack.func_77952_i());
        return super.func_77667_c(stack) + "." + honeyComb.name;
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < EnumHoneyComb.VALUES.length; ++i) {
            EnumHoneyComb honeyComb = EnumHoneyComb.get(i);
            if (honeyComb.isSecret() && !Config.isDebug) continue;
            subItems.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Nullable
    private static EnumHoneyComb getRandomCombType(Random random, boolean includeSecret) {
        ArrayList<EnumHoneyComb> validCombs = new ArrayList<EnumHoneyComb>(EnumHoneyComb.VALUES.length);
        for (int i = 0; i < EnumHoneyComb.VALUES.length; ++i) {
            EnumHoneyComb honeyComb = EnumHoneyComb.get(i);
            if (honeyComb.isSecret() && !includeSecret) continue;
            validCombs.add(honeyComb);
        }
        if (validCombs.isEmpty()) {
            return null;
        }
        return (EnumHoneyComb)((Object)validCombs.get(random.nextInt(validCombs.size())));
    }

    public ItemStack getRandomComb(int amount, Random random, boolean includeSecret) {
        EnumHoneyComb honeyComb = ItemHoneyComb.getRandomCombType(random, includeSecret);
        if (honeyComb == null) {
            return ItemStack.field_190927_a;
        }
        return this.get(honeyComb, amount);
    }

    public ItemStack get(EnumHoneyComb honeyComb, int amount) {
        return new ItemStack((Item)this, amount, honeyComb.ordinal());
    }

    @Override
    public int getColorFromItemstack(ItemStack itemstack, int tintIndex) {
        EnumHoneyComb honeyComb = EnumHoneyComb.get(itemstack.func_77952_i());
        if (tintIndex == 1) {
            return honeyComb.primaryColor;
        }
        return honeyComb.secondaryColor;
    }
}

