/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.factory.gui;

import forestry.core.config.Constants;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import forestry.factory.tiles.TileBottler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiBottler extends GuiForestryTitled<ContainerBottler> {
	private final TileBottler tile;

	public GuiBottler(InventoryPlayer inventory, TileBottler tile) {
		super(Constants.TEXTURE_PATH_GUI + "/bottler.png", new ContainerBottler(inventory, tile), tile);
		this.tile = tile;
		widgetManager.add(new TankWidget(this.widgetManager, 80, 14, 0));
	}

	@Override
	protected void func_146976_a(float var1, int mouseX, int mouseY) {
		bindTexture(textureFile);

		int x = (field_146294_l - field_146999_f) / 2;
		int y = (field_146295_m - field_147000_g) / 2;
		func_73729_b(x, y, 0, 0, field_146999_f, field_147000_g);

		RenderHelper.func_74520_c();
		GlStateManager.func_179140_f();
		GlStateManager.func_179091_B();
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		GlStateManager.func_179094_E();
		{
			GlStateManager.func_179109_b(field_147003_i, field_147009_r, 0.0F);
			drawWidgets();
		}
		GlStateManager.func_179121_F();

		String name = Translator.translateToLocal(tile.getUnlocalizedTitle());
		textLayout.line = 5;
		textLayout.drawCenteredLine(name, 0, ColourProperties.INSTANCE.get("gui.title"));
		bindTexture(textureFile);

		bindTexture(textureFile);

		TileBottler bottler = tile;
		int progressArrow = bottler.getProgressScaled(22);
		if (progressArrow > 0) {
			if (bottler.isFillRecipe) {
				func_73729_b(field_147003_i + 108, field_147009_r + 35, 177, 74, progressArrow, 16);
			} else {
				func_73729_b(field_147003_i + 46, field_147009_r + 35, 177, 74, progressArrow, 16);
			}
		}
	}

	@Override
	protected void addLedgers() {
		addErrorLedger(tile);
		addHintLedger("bottler");
		addPowerLedger(tile.getEnergyManager());
	}
}
