package forestry.core.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InvSlot implements IInvSlot {

	private final IItemHandler inv;
	protected final int slot;

	public InvSlot(IItemHandler inv, int slot) {
		this.inv = inv;
		this.slot = slot;
	}

	@Override
	public int getIndex() {
		return slot;
	}

	@Override
	public boolean canPutStackInSlot(ItemStack stack) {
		ItemStack remainder = inv.insertItem(slot, stack, true);
		return remainder.func_190926_b() || remainder.func_190916_E() < stack.func_190916_E();
	}

	@Override
	public boolean canTakeStackFromSlot(ItemStack stack) {
		return !inv.extractItem(slot, 1, true).func_190926_b();
	}

	@Override
	public ItemStack decreaseStackInSlot() {
		return inv.extractItem(slot, 1, false);
	}

	@Override
	public ItemStack getStackInSlot() {
		return inv.getStackInSlot(slot);
	}

}
