/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui;

import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.TileNaturalistChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;

public class ContainerNaturalistInventory extends ContainerTile<TileNaturalistChest> implements IGuiSelectable {

	public ContainerNaturalistInventory(InventoryPlayer player, TileNaturalistChest tile, int page) {
		super(tile, player, 18, 120);

		addInventory(this, tile, page);
	}

	public static <T extends IInventory & IFilterSlotDelegate> void addInventory(ContainerForestry container, T inventory, int selectedPage) {
		for (int page = 0; page < 5; page++) {
			for (int x = 0; x < 5; x++) {
				for (int y = 0; y < 5; y++) {
					int slot = y + page * 25 + x * 5;
					if (page == selectedPage) {
						container.func_75146_a(new SlotFilteredInventory(inventory, slot, 100 + y * 18, 21 + x * 18));
					} else {
						container.func_75146_a(new SlotFilteredInventory(inventory, slot, -10000, -10000));
					}
				}
			}
		}
	}

	@Override
	public void handleSelectionRequest(EntityPlayerMP player, int primary, int secondary) {
		tile.flipPage(player, (short) primary);
	}

	@Override
	public void func_75132_a(IContainerListener listener) {
		super.func_75132_a(listener);

		tile.increaseNumPlayersUsing();
	}

	@Override
	public void func_75134_a(EntityPlayer player) {
		super.func_75134_a(player);
		tile.decreaseNumPlayersUsing();
	}
}
